"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadConfig = exports.io = exports.data = exports.invokeBackendFunction = exports.useFunctionContext = exports.createBackendFunction = exports.createRequestContext = exports.createRoute = exports.registerBackendComponent = exports.createServer = exports.ServerInstance = exports.utils = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
require('dotenv').config();
const http_1 = __importDefault(require("http"));
const express_1 = __importDefault(require("express"));
const cookie_parser_1 = __importDefault(require("cookie-parser"));
const morgan_1 = __importDefault(require("morgan"));
const server_1 = __importDefault(require("react-dom/server"));
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const node_html_parser_1 = __importDefault(require("node-html-parser"));
const frontend_1 = require("@magicjs.dev/frontend");
const mongodb_1 = require("mongodb");
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const moment_1 = __importDefault(require("moment"));
const utils_1 = __importDefault(require("./utils"));
const url_pattern_1 = __importDefault(require("url-pattern"));
const socket_io_1 = require("socket.io");
const uploader_utils_1 = require("./uploader-utils");
const mern_ai_1 = require("./services/mern.ai");
exports.utils = utils_1.default;
function extractFrontendContext(c) {
    const { currentUser, isAuthenticated, token, roles } = c;
    return {
        currentUser,
        isAuthenticated,
        token,
        roles
    };
}
class ServerInstance {
    static getInstance() {
        if (!ServerInstance.instance) {
            ServerInstance.instance = new ServerInstance();
        }
        return ServerInstance.instance;
    }
    setPort(p) {
        this.port = p;
    }
    constructor() {
        this.port = 8081;
        this.functions = {};
        this.auth = {
            jwtSecret: '77PjsGGRSkemFS@q$aAinTS',
            jwtSignOpts: {
                expiresIn: '1d',
            },
            createCookieOptions: () => {
                return {
                    expires: moment_1.default.utc().add(23, 'hours').toDate()
                };
            }
        };
        (0, mern_ai_1.initaliseMERNAI_Services)();
        this.app = (0, express_1.default)();
        this.httpServer = http_1.default.createServer(this.app);
        this.app.use((0, morgan_1.default)('dev'));
        this.app.use((0, cookie_parser_1.default)());
        this.app.use(express_1.default.json());
        this.app.use(express_1.default.urlencoded());
        this.app.use(express_1.default.text());
        this.app.use(express_1.default.raw());
        this.app.use('/_browser', express_1.default.static(path_1.default.join(__dirname, '../_browser')));
        this.app.use('/assets', express_1.default.static(path_1.default.join(__dirname, '../assets')));
        /** Attach context */
        this.app.use((req, res, next) => __awaiter(this, void 0, void 0, function* () {
            let isAuthenticated = false;
            let currentUser = null;
            let authorization = decodeURIComponent(req.cookies['authorization'] || '');
            if (authorization) {
                authorization = authorization.replace('Bearer', '').trim();
                if (authorization) {
                    const payload = jsonwebtoken_1.default.verify(authorization, this.auth.jwtSecret);
                    if (payload) {
                        currentUser = payload;
                    }
                }
            }
            isAuthenticated = Boolean(currentUser);
            let roles = [];
            if (isAuthenticated === true) {
                roles = yield exports.utils.findAllRolesByUser(currentUser === null || currentUser === void 0 ? void 0 : currentUser._id);
            }
            req.requestContext = createRequestContext({
                roles,
                uploader: (0, uploader_utils_1.createUploaderUtils)(req, res),
                advanced: {
                    req,
                    res,
                },
                coreHandler: (handler) => {
                    if (handler) {
                        Promise.resolve(handler(req, res));
                    }
                    return {
                        ___resMode: 'managed'
                    };
                },
                token: req.cookies['authorization'],
                isAuthenticated,
                currentUser,
                isCurrentUserInAnyRoles(roles) {
                    return __awaiter(this, void 0, void 0, function* () {
                        if (currentUser) {
                            return exports.utils.isUserInAnyRoles(currentUser === null || currentUser === void 0 ? void 0 : currentUser._id, roles);
                        }
                        return false;
                    });
                },
                setCurrentUser: (user) => {
                    var _a, _b, _c, _d;
                    if (user) {
                        /** Login */
                        /** Delete password */
                        delete user.password;
                        const token = jsonwebtoken_1.default.sign(user, this.auth.jwtSecret, this.auth.jwtSignOpts);
                        let cookieOpts = ((_a = this === null || this === void 0 ? void 0 : this.auth) === null || _a === void 0 ? void 0 : _a.createCookieOptions) && ((_b = this === null || this === void 0 ? void 0 : this.auth) === null || _b === void 0 ? void 0 : _b.createCookieOptions());
                        if (!cookieOpts) {
                            cookieOpts = {};
                        }
                        res.cookie('authorization', `Bearer ${token}`, cookieOpts);
                    }
                    else {
                        console.log('Logging out...');
                        /** Logout */
                        let cookieOpts = ((_c = this === null || this === void 0 ? void 0 : this.auth) === null || _c === void 0 ? void 0 : _c.createCookieOptions) && ((_d = this === null || this === void 0 ? void 0 : this.auth) === null || _d === void 0 ? void 0 : _d.createCookieOptions());
                        if (!cookieOpts) {
                            cookieOpts = {};
                        }
                        cookieOpts.expires = moment_1.default.utc().add(-5, 'days').toDate();
                        if (!cookieOpts) {
                            cookieOpts = {};
                        }
                        res.cookie('authorization', `null`, cookieOpts);
                    }
                }
            });
            next();
        }));
        this.app.all('/__backend/__managed/:functionPath(*)', (req, res, next) => __awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            if (['get', 'post'].indexOf(String(req.method).toLowerCase()) < 0) {
                next();
                return;
            }
            const { functionPath } = req.params;
            try {
                const isMultipartFormData = String(req.headers['content-type']).startsWith('multipart/form-data');
                let args = [];
                if (typeof req.query['args'] === 'string') {
                    try {
                        args = JSON.parse(req.query['args']);
                    }
                    catch (e) {
                        console.error(e);
                    }
                }
                if (typeof req.headers['args'] === 'string') {
                    try {
                        args = JSON.parse(req.headers['args']);
                    }
                    catch (e) {
                        console.error(e);
                    }
                }
                if (Array.isArray((_a = req === null || req === void 0 ? void 0 : req.body) === null || _a === void 0 ? void 0 : _a.args)) {
                    args = (_b = req === null || req === void 0 ? void 0 : req.body) === null || _b === void 0 ? void 0 : _b.args;
                }
                if (isMultipartFormData === true) {
                    yield invokeBackendFunction(req.requestContext, functionPath, ...args);
                }
                else {
                    const result = yield invokeBackendFunction(req.requestContext, functionPath, ...args);
                    if ((result === null || result === void 0 ? void 0 : result.___resMode) === 'managed') {
                        // Let the function handle the response
                        if (result === null || result === void 0 ? void 0 : result.reader) {
                            result.reader.pipe(res);
                        }
                        return;
                    }
                    return res.json(result);
                }
            }
            catch (e) {
                return res.status(500).json({
                    message: e === null || e === void 0 ? void 0 : e.message
                });
            }
        }));
        this.app.post('/__backend/__context', (req, res) => __awaiter(this, void 0, void 0, function* () {
            res.json(extractFrontendContext(req.requestContext));
        }));
        this.app.post('/__backend/__context/logout', (req, res) => __awaiter(this, void 0, void 0, function* () {
            req.requestContext.setCurrentUser(null);
            res.json({ ack: true });
        }));
        /* -------------------------------------------------------------------------- */
        /*                                   Socket                                   */
        /* -------------------------------------------------------------------------- */
        this.io = new socket_io_1.Server(this.httpServer, {
            path: '/app-socket'
        });
        this.io.on('connection', (socket) => {
            console.log('A user connected', socket.id);
            socket.on('/__magicjs/rooms/join', (roomIds) => {
                console.log(`User joined ${roomIds.length} room(s)`);
                socket.join(roomIds);
            });
            socket.on('/__magicjs/rooms/leave', (roomIds) => __awaiter(this, void 0, void 0, function* () {
                for (const roomId of roomIds) {
                    yield socket.leave(roomId);
                }
                console.log(`Left ${roomIds.length} rooms`);
            }));
        });
    }
}
exports.ServerInstance = ServerInstance;
const instance = ServerInstance.getInstance();
function createServer(handler, instance) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!instance) {
            instance = ServerInstance.getInstance();
        }
        const MONGO_CONNECTION_STRING = process.env['MONGO_CONNECTION_STRING'];
        if (MONGO_CONNECTION_STRING) {
            console.log('Connecting to db...');
            /** Connect to MongoDB */
            instance.database = new mongodb_1.MongoClient(MONGO_CONNECTION_STRING);
            yield instance.database.connect();
            console.log('Connected to db');
        }
        if (handler) {
            yield Promise.resolve(handler(instance));
        }
        instance.app.get('/*', (req, res, next) => {
            const config = frontend_1.controllerRef.arkConfig;
            if (Array.isArray(config.routes)) {
                const currentPath = req.path;
                const matchingPath = config.routes.filter((r) => {
                    return Boolean(r.path);
                }).find((route) => {
                    const pattern = new url_pattern_1.default(route.path);
                    return pattern.match(currentPath);
                });
                // TODO: Do this only for dev env (BUT CURRENTLY ENABLED FOR ALL)
                res.setHeader("Cache-Control", "no-cache, no-store, must-revalidate"); // HTTP 1.1.
                res.setHeader("Pragma", "no-cache"); // HTTP 1.0.
                res.setHeader("Expires", "0"); // Proxies.
                const shouldRenderOnServer = (matchingPath === null || matchingPath === void 0 ? void 0 : matchingPath.ssr) === true;
                const htmlFilePath = path_1.default.join(__dirname, '../client.html');
                const htmlContent = fs_1.default.readFileSync(htmlFilePath, 'utf-8');
                const htmlContentNode = node_html_parser_1.default.parse(htmlContent);
                const passThruContext = extractFrontendContext(req.requestContext);
                const controller = new frontend_1.FrontendController();
                controller.applets = frontend_1.controllerRef.applets;
                controller.arkConfig = frontend_1.controllerRef.arkConfig;
                controller.registeredComponents = frontend_1.controllerRef.registeredComponents;
                controller.context = passThruContext;
                if (shouldRenderOnServer === true) {
                    let helmetContext = {};
                    const serverRenderedContent = server_1.default.renderToString((0, jsx_runtime_1.jsx)(frontend_1.App, { helmetContext: helmetContext, initialPath: req.path, controller: controller }));
                    let headContent = [];
                    try {
                        headContent = Object.keys((helmetContext === null || helmetContext === void 0 ? void 0 : helmetContext.helmet) || {}).reduce((acc, item) => {
                            let c;
                            try {
                                c = helmetContext.helmet[item].toString();
                            }
                            catch (e) {
                                console.error(e);
                            }
                            // @ts-ignore
                            if (c) {
                                acc.push(c);
                            }
                            return acc;
                        }, []);
                        let i = 0;
                        for (i = 0; i < headContent.length; i++) {
                            const headNode = htmlContentNode
                                .querySelector('head');
                            if (headNode) {
                                headNode.appendChild(node_html_parser_1.default.parse(headContent[i]));
                            }
                        }
                    }
                    catch (e) {
                        console.error(e);
                    }
                    const rootDiv = htmlContentNode.querySelector('#root');
                    if (rootDiv) {
                        rootDiv.set_content(serverRenderedContent);
                    }
                }
                const headCon = htmlContentNode.querySelector('head');
                if (headCon) {
                    const scriptNode = node_html_parser_1.default.parse(`<script>globalThis.___ark_hydrated_state___=${JSON.stringify(Object.assign(Object.assign({}, passThruContext), { shouldHydrate: shouldRenderOnServer }))};</script>`);
                    headCon.appendChild(scriptNode);
                }
                res.send(htmlContentNode.toString());
                return;
            }
            next();
        });
        let DEV_PORT = Number(process.env.DEV_PORT);
        if (isNaN(DEV_PORT)) {
            DEV_PORT = instance.port;
        }
        instance.httpServer.listen(DEV_PORT, undefined, undefined, () => {
            console.log(`Listening on port ${DEV_PORT}`);
        });
        return instance;
    });
}
exports.createServer = createServer;
function registerBackendComponent(_moduleId, module) {
    var _a;
    const instance = ServerInstance.getInstance();
    const arkCompType = (_a = module === null || module === void 0 ? void 0 : module.prototype) === null || _a === void 0 ? void 0 : _a.arkCompType;
    switch (arkCompType || (module === null || module === void 0 ? void 0 : module.type)) {
        case 'express-route': {
            const { path, method, handlers } = module.payload;
            const instance = ServerInstance.getInstance();
            // @ts-ignore
            instance.app[method](path, handlers);
            break;
        }
        case 'backend-function': {
            instance.functions[_moduleId] = module;
            break;
        }
    }
}
exports.registerBackendComponent = registerBackendComponent;
function createRoute(method, path, ...handlers) {
    return {
        type: 'express-route',
        payload: {
            handlers,
            method,
            path
        }
    };
}
exports.createRoute = createRoute;
function createRequestContext(c) {
    return c;
}
exports.createRequestContext = createRequestContext;
function createBackendFunction(fn) {
    fn.prototype.arkCompType = 'backend-function';
    return fn;
}
exports.createBackendFunction = createBackendFunction;
const useFunctionContext = (t) => {
    if (!t) {
        throw new Error('Request context is undefined. Make sure you are invoking the function with proper context.');
    }
    // @ts-ignore
    return t;
};
exports.useFunctionContext = useFunctionContext;
function invokeBackendFunction(requestContext, functionPath, ...args) {
    return __awaiter(this, void 0, void 0, function* () {
        const instance = ServerInstance.getInstance();
        try {
            if (functionPath) {
                const fnPayload = instance.functions[functionPath];
                if (fnPayload) {
                    const result = yield Promise.resolve(fnPayload.call(requestContext, ...args));
                    return result;
                }
            }
            throw new Error(`No such function exists. Looking for function '${functionPath}'`);
        }
        catch (e) {
            throw e;
        }
    });
}
exports.invokeBackendFunction = invokeBackendFunction;
/* -------------------------------------------------------------------------- */
/*                                    Data                                    */
/* -------------------------------------------------------------------------- */
function data(collectionName, dbName) {
    if (!instance.database) {
        throw new Error('Database is not available. Please check the environment variable.');
    }
    return instance.database.db(dbName).collection(collectionName);
}
exports.data = data;
function io() {
    return instance.io;
}
exports.io = io;
/* -------------------------------------------------------------------------- */
/*                                   Config                                   */
/* -------------------------------------------------------------------------- */
function loadConfig(config) {
    const properties = (config === null || config === void 0 ? void 0 : config.properties) || [];
    return {
        getValue(propertyName, defaultVal) {
            const p = properties.find((p) => (p === null || p === void 0 ? void 0 : p.name) === propertyName);
            return (p === null || p === void 0 ? void 0 : p.value) || defaultVal;
        }
    };
}
exports.loadConfig = loadConfig;
