"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalUserUploadServices = void 0;
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importDefault(require("path"));
function getUserUploadPath(dir) {
    return path_1.default.join(process.cwd(), 'user-uploads', dir);
}
class LocalUserUploadServices {
    saveFileToUserUploads(dir, name, file) {
        const uploadPath = getUserUploadPath(dir);
        fs_extra_1.default.mkdirSync(uploadPath, { recursive: true });
        const writer = fs_extra_1.default.createWriteStream(path_1.default.join(uploadPath, name), { autoClose: true });
        file.pipe(writer);
    }
    removeFileFromUserUploads(dir, name) {
        return __awaiter(this, void 0, void 0, function* () {
            let filePath = getUserUploadPath(dir);
            filePath = path_1.default.join(filePath, name || '');
            if (fs_extra_1.default.existsSync(filePath)) {
                fs_extra_1.default.rmSync(filePath);
            }
            return true;
        });
    }
    readFileFromUserUploads(dir, name) {
        return __awaiter(this, void 0, void 0, function* () {
            let filePath = getUserUploadPath(dir);
            filePath = path_1.default.join(filePath, name || '');
            if (fs_extra_1.default.existsSync(filePath)) {
                const reader = fs_extra_1.default.createReadStream(filePath, { autoClose: true });
                return {
                    ___resMode: 'managed',
                    reader: reader
                };
            }
            else {
                throw new Error(`Request resource not found in the server`);
            }
        });
    }
}
exports.LocalUserUploadServices = LocalUserUploadServices;
