"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MERNAI_Core = void 0;
const axios_1 = __importDefault(require("axios"));
class MERNAI_Core {
    get isEnabled() {
        if (this._isEnabled === false) {
            console.warn(`MERN.AI services not enabled, hence some functionalities won't work as expected.`);
        }
        return this._isEnabled;
    }
    set isEnabled(val) {
        this._isEnabled = val;
    }
    get userUploadServiceEnabled() {
        if (this._userUploadServiceEnabled === false) {
            console.warn(`MERN.AI User Uploads service not enabled, hence upload functionalities won't work as expected.`);
        }
        return this._userUploadServiceEnabled;
    }
    set userUploadServiceEnabled(val) {
        this._userUploadServiceEnabled = val;
    }
    constructor() {
        this._isEnabled = false;
        this._userUploadServiceEnabled = false;
        const { WS_CRED_SERVICE_TENANT_ID, WS_CRED_SERVICE_CLIENT_ID, WS_CRED_SERVICE_CLIENT_SECRET, WS_PROJECT_ID, WS_ENVIRONMENT_ID } = process.env || {};
        this.isEnabled = Boolean(WS_CRED_SERVICE_TENANT_ID)
            && Boolean(WS_CRED_SERVICE_CLIENT_ID)
            && Boolean(WS_CRED_SERVICE_CLIENT_SECRET)
            && Boolean(WS_PROJECT_ID);
        this.userUploadServiceEnabled = this.isEnabled && Boolean(WS_ENVIRONMENT_ID);
        if (this._isEnabled === true) {
            this.client = axios_1.default.create({
                baseURL: 'https://compass-services.skyslit.com',
                headers: {
                    'tenantid': WS_CRED_SERVICE_TENANT_ID,
                    'clientid': WS_CRED_SERVICE_CLIENT_ID,
                    'clientsecret': WS_CRED_SERVICE_CLIENT_SECRET,
                    'projectid': WS_PROJECT_ID
                }
            });
        }
        else {
            this.client = null;
        }
    }
}
exports.MERNAI_Core = MERNAI_Core;
