"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initaliseMERNAI_Services = void 0;
const __1 = require("..");
const LocalUserUploadServices_1 = require("../local/LocalUserUploadServices");
const EmailVerificationServices_1 = require("./EmailVerificationServices");
const UserUploadServices_1 = require("./UserUploadServices");
function initaliseMERNAI_Services() {
    const NODE_ENV = process.env['NODE_ENV'];
    const IS_DEVELOPMENT = NODE_ENV === undefined || NODE_ENV === 'development';
    (0, __1.registerService)('email-verify-services', new EmailVerificationServices_1.EmailVerificationServices());
    /** Initialise user upload services */
    if (IS_DEVELOPMENT === true && process.env['USER_UPLOAD_SERVICES'] !== 'MERN.AI') {
        console.log('Local User Upload service initialised');
        (0, __1.registerService)('user-upload-services', new LocalUserUploadServices_1.LocalUserUploadServices());
    }
    else {
        console.log('MERN.AI User Upload service initialised');
        (0, __1.registerService)('user-upload-services', new UserUploadServices_1.UserUploadServices());
    }
}
exports.initaliseMERNAI_Services = initaliseMERNAI_Services;
