#!/usr/bin/env node
"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const build_1 = require("./build");
const init_1 = require("./init");
const command_line_args_1 = __importDefault(require("command-line-args"));
const publish_1 = require("./publish");
const add_feature_1 = require("./add-feature");
const package_json_1 = __importDefault(require("../package.json"));
process.on('SIGINT', function () {
    console.log("\nGracefully shutting down from SIGINT (Ctrl-C)");
    // some other closing procedures go here
    process.exit(0);
});
const optionDefinitions = [
    { name: 'start', alias: 's', type: Boolean },
    { name: 'runtimeUrl', type: String },
    { name: 'build', alias: 'b', type: Boolean },
    { name: 'init', alias: 'i', type: Boolean },
    { name: 'publish', alias: 'p', type: Boolean },
    { name: 'feature', type: String },
    { name: 'secretKey', type: String },
    { name: 'add-feature', type: Boolean },
    { name: 'package', type: String },
    { name: 'name', type: String },
    { name: 'version', alias: 'v', type: Boolean },
];
const options = (0, command_line_args_1.default)(optionDefinitions);
if (options.start === true) {
    const runtimeUrl = options.runtimeUrl;
    (0, build_1.buildApp)(true, runtimeUrl);
}
else if (options.build === true) {
    (0, build_1.buildApp)(false);
}
else if (options.init === true) {
    (0, init_1.init)();
}
else if (options.publish === true) {
    const feature = options.feature;
    const secretKey = options.secretKey;
    if (!feature) {
        throw new Error(`Feature is required`);
    }
    if (!secretKey) {
        throw new Error(`secretKey is required`);
    }
    (0, publish_1.publish)(feature, secretKey);
}
else if (options['add-feature'] === true) {
    const name = options.name;
    const packageId = options.package;
    if (!name) {
        throw new Error(`name is required`);
    }
    if (!packageId) {
        throw new Error(`package is required`);
    }
    (0, add_feature_1.addFeature)(name, packageId);
}
else if (options['version'] === true) {
    console.log(package_json_1.default.version);
}
else {
    console.log('No supported command found');
}
