"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createGhostFile = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const ejs_1 = __importDefault(require("ejs"));
/**
 * Read EJS template
 * @param {string} templatePath
 * @return {string}
 */
function readTemplate(templatePath) {
    return fs_1.default.readFileSync(templatePath, 'utf-8');
}
/**
 * Creates Ghost file
 * @param {string} templatePath
 * @param {string} relPath
 * @param {any=} data
 * @return {GhostFileActions}
 */
function createGhostFile(templatePath, relPath, data) {
    return {
        eject: (contextPath) => {
            const output = ejs_1.default.render(readTemplate(templatePath), data);
            const targetDirPath = path_1.default.dirname(path_1.default.join(contextPath, relPath));
            if (!fs_1.default.existsSync(targetDirPath)) {
                fs_1.default.mkdirSync(targetDirPath, { recursive: true });
            }
            fs_1.default.writeFileSync(path_1.default.join(contextPath, relPath), output);
        },
        provide: (contextPath) => {
            // Check if file already exists
            const targetFilePath = path_1.default.join(contextPath, relPath);
            if (fs_1.default.existsSync(targetFilePath)) {
                return {};
            }
            else {
                const output = ejs_1.default.render(readTemplate(templatePath), data);
                return {
                    [relPath]: output,
                };
            }
        },
    };
}
exports.createGhostFile = createGhostFile;
