"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const backend_module_extractor_1 = require("../utils/backend-module-extractor");
const path_1 = __importDefault(require("path"));
function default_1(source) {
    let rPath = this.resourcePath;
    let cwd = process.cwd();
    rPath = rPath.split(path_1.default.sep).join(path_1.default.posix.sep);
    cwd = cwd.split(path_1.default.sep).join(path_1.default.posix.sep);
    const isARemoteFile = String(rPath).endsWith('.server.tsx');
    if (isARemoteFile === true) {
        const backendModuleId = (0, backend_module_extractor_1.extractBackendModuleId)(cwd, path_1.default.posix.relative(cwd, rPath));
        return `
        import { controllerRef } from '@magicjs.dev/frontend';

        const fullPath = '/__backend/__managed/' + '${backendModuleId}';

        async function invoke (...args: any[]) {
            try {
                const res = await controllerRef.client.post(fullPath, {
                    args
                }, {
                    withCredentials: true
                });

                return res.data;
            } catch (e) {
                throw new Error((e?.response?.data?.message ? e?.response?.data?.message : e?.message) || 'Network error');
            }
            return "Calling api at ${backendModuleId}"
        }

        invoke.prototype.__fullPath = fullPath;
        invoke.prototype.__backendModuleId = '${backendModuleId}';

        export default invoke`;
    }
    return source;
}
exports.default = default_1;
