"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateAutoloaderFile = exports.generator = void 0;
const fs_extra_1 = __importDefault(require("fs-extra"));
const case_1 = __importDefault(require("case"));
const fast_glob_1 = __importDefault(require("fast-glob"));
const path_1 = __importDefault(require("path"));
const backend_module_extractor_1 = require("./backend-module-extractor");
function* infinite() {
    let index = 0;
    let timestamp = (new Date()).valueOf();
    const g = () => `${index}`;
    while (true) {
        index++;
        yield g();
    }
    return g();
}
exports.generator = infinite();
function generateAutoloaderFile(cwd, target) {
    let lazyLoadingEnabled = target === 'frontend';
    let importExpressions = '';
    let registrationExpressions = '';
    const arkJSONPath = path_1.default.join(cwd, 'src', 'app.json');
    const arkJSON = JSON.parse(fs_extra_1.default.readFileSync(arkJSONPath, 'utf-8'));
    if (Array.isArray(arkJSON.routes)) {
        const importables = arkJSON.routes.map((route) => {
            return {
                path: route.path,
                type: 'view',
                pageId: (route === null || route === void 0 ? void 0 : route.pageId) || null,
                filePath: `./${path_1.default.posix.relative(path_1.default.posix.join(cwd, 'src'), path_1.default.posix.join(cwd, 'src', route.view))}`,
                fileId: case_1.default.pascal(route.view)
            };
        });
        // Load applets
        if (fs_extra_1.default.existsSync(path_1.default.join(cwd, 'src', 'features'))) {
            const dirs = fs_extra_1.default.readdirSync(path_1.default.join(cwd, 'src', 'features'), { withFileTypes: true }).filter((f) => f.isDirectory()).map((f) => f.name);
            for (const feature of dirs) {
                const featurePath = path_1.default.posix.join(cwd, 'src', 'features', feature);
                let config = null;
                try {
                    if (fs_extra_1.default.existsSync(path_1.default.join(featurePath, 'config.json'))) {
                        config = JSON.parse(fs_extra_1.default.readFileSync(path_1.default.join(featurePath, 'config.json'), 'utf-8'));
                    }
                }
                catch (e) {
                    console.error(e);
                }
                if (!config) {
                    config = {};
                }
                if (!Array.isArray(config.applets)) {
                    config.applets = [];
                }
                const applets = fast_glob_1.default.sync(['**/**.tsx'], { dot: false, cwd: featurePath });
                for (const appletFileName of applets) {
                    const relativePathToApplet = `${path_1.default.posix.relative(path_1.default.posix.join(cwd, 'src'), path_1.default.posix.join(featurePath, appletFileName))}`;
                    const genricPath = path_1.default.posix.join(path_1.default.posix.dirname(relativePathToApplet), path_1.default.posix.parse(path_1.default.posix.basename(relativePathToApplet)).name);
                    const genricPathWithExt = path_1.default.posix.join(path_1.default.posix.dirname(relativePathToApplet), path_1.default.posix.basename(relativePathToApplet));
                    const defaultLabel = path_1.default.posix.relative('features', genricPath);
                    const appletConfig = (config.aliases || config.applets || []).find((a) => {
                        return a.fileName === appletFileName;
                    });
                    importables.push({
                        path: null,
                        type: 'applet',
                        featurePath: path_1.default.posix.relative(path_1.default.posix.join(cwd, 'src'), featurePath),
                        filePath: `./${relativePathToApplet}`,
                        fileId: case_1.default.pascal(path_1.default.posix.join(feature, appletFileName)),
                        resolvers: [
                            genricPath,
                            genricPathWithExt,
                            (appletConfig === null || appletConfig === void 0 ? void 0 : appletConfig.alias) || null
                        ].filter(Boolean),
                        mounts: ((appletConfig === null || appletConfig === void 0 ? void 0 : appletConfig.mounts) || []),
                        genricPath,
                        defaultLabel,
                        appletConfig
                    });
                }
            }
        }
        const uniqueImportables = importables.reduce((acc, importable, index, items) => {
            const alreadyAdded = acc.findIndex((a) => a.fileId === importable.fileId) > -1;
            if (alreadyAdded === false) {
                acc.push(importable);
            }
            return acc;
        }, []);
        importExpressions = uniqueImportables.map((importable) => {
            if (lazyLoadingEnabled === true) {
                return `const ${importable.fileId} = lazy(() => import('${importable.filePath}'));`;
            }
            return `import ${importable.fileId} from '${importable.filePath}';`;
        }).join('\n');
        registrationExpressions = importables
            .map((importable) => {
            if (importable.type === 'view') {
                if (lazyLoadingEnabled === true) {
                    const id = exports.generator.next().value;
                    return `
                        const ${importable.fileId}_COMP${id} = (props: any) => {
                        return (
                            <${importable.fileId} {...props} />
                        )
                        }
                
                        registerView('${importable.path}', '${importable.fileId}', attachRouteMeta(${JSON.stringify(importable)}, ${importable.fileId}_COMP${id}));
                    `;
                }
                else {
                    return `
                        registerView('${importable.path}', '${importable.fileId}', attachRouteMeta(${JSON.stringify(importable)}, ${importable.fileId}));
                    `;
                }
            }
            else if (importable.type === 'applet') {
                const id = exports.generator.next().value;
                if (lazyLoadingEnabled === true) {
                    return (`
                        const ${importable.fileId}_COMP${id} = (props: any) => {
                            return (
                            <${importable.fileId} {...props} />
                            )
                        }
    
                        registerApplet(${JSON.stringify(importable)}, attachAppletMeta(${JSON.stringify(importable)}, ${importable.fileId}_COMP${id}));
                        `);
                }
                else {
                    return `
                        registerApplet(${JSON.stringify(importable)}, attachAppletMeta(${JSON.stringify(importable)}, ${importable.fileId}));
                    `;
                }
            }
            return '';
        }).join('\n');
    }
    let arkBackendImportSt = '';
    let backendImportExpressions = '';
    let backendregistrationExpressions = '';
    if (target === 'backend') {
        arkBackendImportSt = `import { registerBackendComponent } from '@magicjs.dev/backend'`;
        // Load all backend modules
        const entries = fast_glob_1.default.sync(['src/**/**.server.tsx'], { dot: false, cwd });
        const backendImportables = entries.map((filePath) => {
            return {
                filePath: `./${path_1.default.posix.relative(path_1.default.posix.join(cwd, 'src'), path_1.default.posix.join(cwd, filePath))}`,
                moduleVarName: case_1.default.camel(path_1.default.posix.relative(path_1.default.posix.join(cwd, 'src', 'backend'), path_1.default.posix.join(cwd, filePath))),
                moduleId: (0, backend_module_extractor_1.extractBackendModuleId)(cwd, filePath)
            };
        });
        backendImportExpressions = backendImportables.map((importable) => `import ${importable.moduleVarName} from '${importable.filePath}';`).join('\n');
        backendregistrationExpressions = backendImportables.map((importable) => `registerBackendComponent('${importable.moduleId}', ${importable.moduleVarName});`).join('\n');
    }
    const content = `
      import React, { lazy } from 'react';
      import { registerView, registerApplet, controllerRef, attachRouteMeta, attachAppletMeta } from '@magicjs.dev/frontend';
      import './root.scss';
      import arkConfig from './app.json';
      ${arkBackendImportSt}

      ${backendImportExpressions}
      ${importExpressions}
      
      controllerRef.arkConfig = arkConfig;
      
      export function initializeModules() {
          ${backendregistrationExpressions}
          ${registrationExpressions}
      }
    `;
    return content;
}
exports.generateAutoloaderFile = generateAutoloaderFile;
