"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackendRemote = void 0;
const axios_1 = __importDefault(require("axios"));
class BackendRemote {
    static getInstance() {
        if (!BackendRemote.instance) {
            BackendRemote.instance = new BackendRemote();
        }
        return BackendRemote.instance;
    }
    constructor() {
        this.function = {
            call: (path, ...args) => __awaiter(this, void 0, void 0, function* () {
                var _a, _b;
                try {
                    const res = yield (0, axios_1.default)({
                        baseURL: '/__backend/__managed/functions',
                        url: path,
                        method: 'post',
                        data: {
                            args
                        }
                    });
                    return res.data;
                }
                catch (e) {
                    throw new Error((((_b = (_a = e === null || e === void 0 ? void 0 : e.response) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.message) || (e === null || e === void 0 ? void 0 : e.message)) || 'Unknown network error');
                }
            })
        };
    }
}
exports.BackendRemote = BackendRemote;
