import traverse from 'traverse';
export type CMSLog = {
    key: string;
    val: any;
    version?: number;
    id?: number;
    clientId?: string;
    timestamp?: string;
    prevValueType?: string;
    previousValue?: string;
};
/**
 * Resolves a complete object address to the current index
 * @param {traverse.Traverse<any>} traverseResult
 * @param {string} inputAddress
 * @return {string}
 */
export declare function resolveAddressForTraversal(traverseResult: traverse.Traverse<any>, inputAddress: string): string;
/**
 * Resolves traversal paths to address
 * @param {string[]} paths
 * @return {string}
 */
export declare function resolveTraversalAddressFromPath(paths: string[]): string;
/**
 * Resolves index of array item from the ID template
 * @param {traverse.Traverse<any>} traverseResult
 * @param {string} path
 * @param {string} query
 * @return {number}
 */
export declare function resolveIndexFromTraversalResult(traverseResult: traverse.Traverse<any>, path: string, query: string): number;
export type CMSApplyMode = 'sync' | 'edit';
export declare function applyLog(content: any, key: string, val: any, mode: CMSApplyMode, track: (prevVal: any, prevValType: any) => void): any;
export declare function sortLogs(actions: Array<CMSLog>): CMSLog[];
export declare function updateContent(content: any, actions: Array<CMSLog>, mode: CMSApplyMode): {
    appliedActions: CMSLog[];
    content: any;
};
export declare const CMS: {
    applyLog: typeof applyLog;
    updateContent: typeof updateContent;
};
