import React from "react";
import { CMSLog } from './content-core';
type ContentHookOptions<T> = {
    serviceId: string;
    defaultContent: T;
    useReduxStore: boolean;
    enableLocalStorage?: boolean;
};
export declare function useContent<T>(opts_?: string | Partial<ContentHookOptions<T>>): {
    isAvailable: boolean;
    hasChanged: boolean;
    content: any;
    actionLogs: React.MutableRefObject<CMSLog[]>;
    runBatch: (fn: (content: any) => void) => void;
    reset: () => void;
    setContent: (val: any) => void;
    markAsSaved: () => void;
    getPendingLogs: () => CMSLog[];
    resetPendingLogs: () => void;
    insertItem: (key: any, indexToInsert: any, val: any) => void;
    pushItem: (key: any, val: any) => void;
    unshiftItem: (key: any, val: any) => void;
    removeItemAt: (key: any, index: any) => void;
    updateKey: (key: string, val: any) => void;
    saveLocally: () => void;
    hasLocalData: () => boolean;
};
export {};
