"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadButton = exports.createSrc = exports.createUploader = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = __importDefault(require("react"));
const axios_1 = __importDefault(require("axios"));
const ui_utils_1 = require("./ui-utils");
function createUploader(backendFn, useOriginalFileNames = false) {
    const [files, addFiles] = react_1.default.useState();
    const [loading, setLoading] = react_1.default.useState(false);
    const [uploadProgress, setUploadProgress] = react_1.default.useState(0);
    const readyToUpload = react_1.default.useMemo(() => {
        return files && files.length > 0;
    }, [files]);
    const upload = react_1.default.useCallback((...args) => __awaiter(this, void 0, void 0, function* () {
        if (files) {
            try {
                setLoading(true);
                setUploadProgress(0);
                const apiPath = backendFn.prototype.__fullPath;
                const formData = new FormData();
                let i;
                let uploadedFiles = [];
                for (i = 0; i < files.length; i++) {
                    let name = files[i].name;
                    if (useOriginalFileNames === false) {
                        name = ui_utils_1.uiUtils.generateUniqueFilename(name);
                    }
                    uploadedFiles.push(name);
                    formData.append(`file_${i}`, new File([files[i]], name, { type: files[i].type }));
                }
                const response = yield (0, axios_1.default)({
                    data: formData,
                    method: 'post',
                    url: apiPath,
                    onUploadProgress: progressEvent => {
                        const { loaded, total } = progressEvent;
                        const percentCompleted = Math.round((loaded * 100) / total);
                        if (!isNaN(percentCompleted)) {
                            setUploadProgress(percentCompleted);
                        }
                    },
                    headers: {
                        'Content-Type': 'multipart/form-data',
                        'args': JSON.stringify(args)
                    }
                });
                setUploadProgress(100);
                setLoading(false);
                return uploadedFiles;
            }
            catch (e) {
                setLoading(false);
                throw e;
            }
        }
    }), [backendFn, files, useOriginalFileNames]);
    return {
        files,
        addFiles,
        readyToUpload,
        upload,
        loading,
        uploadProgress
    };
}
exports.createUploader = createUploader;
function createSrc(backendFn) {
    return {
        getLink: (...args) => {
            var _a;
            const apiPath = (_a = backendFn === null || backendFn === void 0 ? void 0 : backendFn.prototype) === null || _a === void 0 ? void 0 : _a.__fullPath;
            if (!apiPath) {
                throw new Error(`backendFn is invalid`);
            }
            const url = new URL('http://localhost');
            url.pathname = apiPath;
            if (args.length > 0) {
                url.searchParams.set('args', JSON.stringify(args));
            }
            return `${url.pathname}${url.search}`;
        }
    };
}
exports.createSrc = createSrc;
function UploadButton(props) {
    const [err, setErr] = react_1.default.useState(null);
    const { readyToUpload, addFiles, files, loading, uploadProgress, upload } = createUploader(props.backendFn, props.useOriginalFileNames);
    if (loading === true) {
        return ((0, jsx_runtime_1.jsx)("span", { children: `Uploading (${uploadProgress}%)` }));
    }
    if (err) {
        return ((0, jsx_runtime_1.jsx)("span", { children: (err === null || err === void 0 ? void 0 : err.message) || 'Upload error' }));
    }
    if (readyToUpload === true) {
        return ((0, jsx_runtime_1.jsx)("button", { onClick: () => {
                setErr(null);
                upload(props === null || props === void 0 ? void 0 : props.uploadArg)
                    .then((uploadedFiles) => {
                    addFiles(null);
                    return uploadedFiles;
                })
                    .then((uploadedFiles) => (props === null || props === void 0 ? void 0 : props.onUpload) && (props === null || props === void 0 ? void 0 : props.onUpload(uploadedFiles)))
                    .catch((err) => setErr(err));
            }, className: `${props === null || props === void 0 ? void 0 : props.className} ${props === null || props === void 0 ? void 0 : props.uploadBtnClassName}`, style: Object.assign(Object.assign(Object.assign({}, ((props === null || props === void 0 ? void 0 : props.style) || {})), ((props === null || props === void 0 ? void 0 : props.uploadBtnStyle) || {})), { cursor: 'pointer' }), children: `Upload ${files.length} file(s)` }));
    }
    return ((0, jsx_runtime_1.jsxs)("label", { className: props === null || props === void 0 ? void 0 : props.className, style: Object.assign(Object.assign({}, ((props === null || props === void 0 ? void 0 : props.style) || {})), { cursor: 'pointer' }), children: ["Choose File", (0, jsx_runtime_1.jsx)("input", Object.assign({}, props === null || props === void 0 ? void 0 : props.inputProps, { type: "file", onChange: (e) => addFiles(e.target.files), style: { display: 'none' } }))] }));
}
exports.UploadButton = UploadButton;
