"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePromise = exports.waitInMs = exports.uiUtils = exports.useContent = exports.UploadButton = exports.createSrc = exports.createUploader = exports.loadConfig = exports.startApp = exports.App = exports.goBackToReturnPath = exports.RedirectToLoginPage = exports.Protected = exports.useMounts = exports.Mount = exports.Applet = exports.importUI = exports.Link = exports.LinkDisplay = exports.useParams = exports.useRoute = exports.useAppletMeta = exports.useRouteMeta = exports.attachAppletMeta = exports.attachRouteMeta = exports.registerApplet = exports.registerView = exports.createComponent = exports.useSocket = exports.useController = exports.useAxios = exports.useLogin = exports.SocketContext = exports.ControllerContext = exports.controllerRef = exports.backend = exports.FrontendController = exports.generator = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = __importDefault(require("react"));
const client_1 = require("react-dom/client");
const react_helmet_async_1 = require("react-helmet-async");
const url_pattern_1 = __importDefault(require("url-pattern"));
const backend_1 = require("./backend");
const axios_1 = __importDefault(require("axios"));
const path_1 = __importDefault(require("path"));
const socket_1 = require("./socket");
const react_error_boundary_1 = require("react-error-boundary");
const path = path_1.default.posix;
function* infinite() {
    let index = 0;
    let timestamp = (new Date()).valueOf();
    const g = () => `${timestamp}_${index}`;
    while (true) {
        index++;
        yield g();
    }
    return g();
}
exports.generator = infinite();
const getCookies = function () {
    var pairs = document.cookie.split(";");
    var cookies = {};
    for (var i = 0; i < pairs.length; i++) {
        var pair = pairs[i].split("=");
        cookies[(pair[0] + '').trim()] = unescape(pair.slice(1).join('='));
    }
    return cookies;
};
class FrontendController {
    static getInstance() {
        if (!FrontendController.instance) {
            FrontendController.instance = new FrontendController();
        }
        return FrontendController.instance;
    }
    subscribe(event, handler) {
        let id = String(exports.generator.next().value);
        if (!this.map[event]) {
            this.map[event] = {};
        }
        this.map[event][id] = (...args) => __awaiter(this, void 0, void 0, function* () {
            try {
                if (handler) {
                    yield Promise.resolve(handler(...args));
                }
            }
            catch (e) {
                console.error(e);
            }
        });
        return () => {
            delete this.map[event][id];
        };
    }
    emit(event, ...args) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.map[event]) {
                const handlers = Object.keys(this.map[event]).map((k) => this.map[event][k]);
                yield Promise.allSettled(handlers.map((h) => h && h(...args)));
            }
        });
    }
    refreshContext() {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield axios_1.default.post('/__backend/__context');
            this.context = res.data;
            this.emit('core/context/change', this.context);
        });
    }
    setAuthCookie(v) {
        var _a;
        const hasChanged = ((_a = this === null || this === void 0 ? void 0 : this.context) === null || _a === void 0 ? void 0 : _a.token) !== v;
        if (hasChanged === true) {
            this.refreshContext();
        }
        this.context.token = v;
    }
    constructor() {
        this.registeredComponents = [];
        this.arkConfig = null;
        this.context = {
            token: null,
            isAuthenticated: false,
            currentUser: null
        };
        this.map = {};
        this.applets = [];
        this.client = axios_1.default.create();
        this.socketController = new socket_1.SocketController();
        this.refreshContext.bind(this);
        this.client.interceptors.response.use((v) => {
            let authToken = getCookies();
            authToken = authToken['authorization'] || null;
            this.setAuthCookie(authToken);
            return v;
        });
        /** Attempt to hydrate the state */
        try {
            // @ts-ignore
            const ___ark_hydrated_state___ = globalThis['___ark_hydrated_state___'];
            if (___ark_hydrated_state___) {
                this.context = ___ark_hydrated_state___;
            }
        }
        catch (e) {
            console.error(e);
        }
    }
}
exports.FrontendController = FrontendController;
exports.backend = backend_1.BackendRemote.getInstance();
exports.controllerRef = FrontendController.getInstance();
// @ts-ignore
exports.ControllerContext = react_1.default.createContext(null);
// @ts-ignore
exports.SocketContext = react_1.default.createContext(null);
/* -------------------------------------------------------------------------- */
/*                                 Core Hooks                                 */
/* -------------------------------------------------------------------------- */
function useLogin() {
    const controller = react_1.default.useContext(exports.ControllerContext);
    const [context, setContext] = react_1.default.useState(controller.context);
    react_1.default.useEffect(() => {
        const handler = (ctx) => {
            setContext(ctx);
        };
        const unsub = controller.subscribe('core/context/change', handler);
        return unsub;
    }, []);
    const logout = react_1.default.useCallback(() => __awaiter(this, void 0, void 0, function* () {
        return yield controller.client.post('/__backend/__context/logout');
    }), []);
    const isCurrentUserInAnyRoles = react_1.default.useCallback((roles) => {
        if (!Array.isArray(roles)) {
            roles = [roles];
        }
        if (Array.isArray(context === null || context === void 0 ? void 0 : context.roles) && (context === null || context === void 0 ? void 0 : context.roles.length) > 0) {
            return Boolean(context.roles.find((r) => roles.indexOf(r.role) > -1));
        }
        return false;
    }, [context === null || context === void 0 ? void 0 : context.roles]);
    return { current: context, logout, isCurrentUserInAnyRoles };
}
exports.useLogin = useLogin;
function useAxios() {
    const { controller } = useController();
    return controller.client;
}
exports.useAxios = useAxios;
function useController() {
    const controller = react_1.default.useContext(exports.ControllerContext);
    return { controller };
}
exports.useController = useController;
function useSocket() {
    return react_1.default.useContext(exports.SocketContext);
}
exports.useSocket = useSocket;
function createComponent(component) {
    return component;
}
exports.createComponent = createComponent;
function registerView(path, id, Component) {
    exports.controllerRef.registeredComponents.push({
        path,
        Component
    });
}
exports.registerView = registerView;
function registerApplet(meta, Component) {
    exports.controllerRef.applets.push(Object.assign(Object.assign({}, meta), { Component }));
}
exports.registerApplet = registerApplet;
// @ts-ignore
const RouteProvider = react_1.default.createContext(null);
const RouteMetaContext = react_1.default.createContext(null);
const AppletMetaContext = react_1.default.createContext(null);
function attachRouteMeta(routeMeta, Comp) {
    return (props) => ((0, jsx_runtime_1.jsx)(RouteMetaContext.Provider, { value: routeMeta, children: (0, jsx_runtime_1.jsx)(Comp, Object.assign({}, props)) }));
}
exports.attachRouteMeta = attachRouteMeta;
function attachAppletMeta(appletMeta, Comp) {
    return (props) => ((0, jsx_runtime_1.jsx)(AppletMetaContext.Provider, { value: appletMeta, children: (0, jsx_runtime_1.jsx)(Comp, Object.assign({}, props)) }));
}
exports.attachAppletMeta = attachAppletMeta;
function useRouteMeta() {
    return react_1.default.useContext(RouteMetaContext);
}
exports.useRouteMeta = useRouteMeta;
function useAppletMeta() {
    return react_1.default.useContext(AppletMetaContext);
}
exports.useAppletMeta = useAppletMeta;
function createRoute(defaultRoot, controller) {
    var _a, _b;
    const [isInitialRender, setIsInitialRender] = react_1.default.useState(true);
    const [pathname, setPathname] = react_1.default.useState(defaultRoot || ((_b = (_a = globalThis === null || globalThis === void 0 ? void 0 : globalThis.window) === null || _a === void 0 ? void 0 : _a.location) === null || _b === void 0 ? void 0 : _b.pathname));
    react_1.default.useEffect(() => {
        window.onpopstate = () => {
            setIsInitialRender(false);
            setPathname(window.location.pathname);
        };
    }, []);
    const push = react_1.default.useCallback((path) => {
        window.history.pushState({}, '', path);
        setIsInitialRender(false);
        const url = new URL(path, `http://localhost`);
        setPathname(url.pathname);
    }, []);
    const [match, component] = react_1.default.useMemo(() => {
        let match;
        let component;
        for (const item of controller.registeredComponents) {
            const pattern = new url_pattern_1.default(item.path);
            match = pattern.match(pathname);
            if (match) {
                component = item;
                break;
            }
        }
        return [match, component];
    }, [pathname]);
    const getQuery = react_1.default.useCallback(() => {
        const url = new URL(window.location.href);
        let r = {};
        url.searchParams.forEach((v, k) => {
            r[k] = v;
        });
        return r;
    }, []);
    return {
        pathname,
        match,
        component,
        push,
        isInitialRender,
        getQuery
    };
}
function useRoute() {
    return react_1.default.useContext(RouteProvider);
}
exports.useRoute = useRoute;
function useParams() {
    const { pathname } = useRoute();
    const routeMeta = useRouteMeta();
    const appletMeta = useAppletMeta();
    const { controller } = useController();
    const routeInfo = react_1.default.useMemo(() => {
        return getRouteInfoByPageId(routeMeta === null || routeMeta === void 0 ? void 0 : routeMeta.pageId, controller);
    }, [pathname, routeMeta === null || routeMeta === void 0 ? void 0 : routeMeta.pageId]);
    let url = react_1.default.useMemo(() => {
        if (routeInfo) {
            const { path } = routeInfo;
            try {
                return path;
            }
            catch (e) {
                console.error(e);
                return path;
            }
        }
        return '';
    }, [routeInfo]);
    let appletUrl = react_1.default.useMemo(() => {
        if (appletMeta) {
            let mounts = getMountsByPageId(routeMeta === null || routeMeta === void 0 ? void 0 : routeMeta.pageId, controller);
            let currentMount = mounts.find((m) => m.appletId === (appletMeta === null || appletMeta === void 0 ? void 0 : appletMeta.genricPath));
            return (currentMount === null || currentMount === void 0 ? void 0 : currentMount.path) || '';
        }
        return '';
    }, [pathname, routeMeta === null || routeMeta === void 0 ? void 0 : routeMeta.pageId]);
    const finalUrl = react_1.default.useMemo(() => {
        return path.join(url, appletUrl);
    }, [url, appletUrl]);
    const params = react_1.default.useMemo(() => {
        const pattern = new url_pattern_1.default(finalUrl);
        return pattern.match(pathname);
    }, [finalUrl, pathname]);
    return params;
}
exports.useParams = useParams;
function PageRenderer(props) {
    const { component, isInitialRender, pathname } = useRoute();
    if (!(component === null || component === void 0 ? void 0 : component.Component)) {
        return ((0, jsx_runtime_1.jsx)("iframe", { style: { width: '100vw', height: '100vh' }, src: `https://mern.ai/templates/__notfound?path=${pathname}` }));
    }
    const Component = react_1.default.useMemo(() => {
        return component.Component;
    }, [component.Component]);
    if (isInitialRender === false) {
        return ((0, jsx_runtime_1.jsx)(react_1.default.Suspense, { fallback: (0, jsx_runtime_1.jsx)("div", {}), children: (0, jsx_runtime_1.jsx)(Component, Object.assign({}, props)) }));
    }
    return ((0, jsx_runtime_1.jsx)(Component, Object.assign({}, props)));
}
function getRouteInfoByPageId(pageId, controller) {
    var _a;
    if (Array.isArray((_a = controller === null || controller === void 0 ? void 0 : controller.arkConfig) === null || _a === void 0 ? void 0 : _a.routes)) {
        return controller.arkConfig.routes.find((r) => r.pageId === pageId);
    }
    return null;
}
function LinkDisplay(props) {
    const { params } = props;
    const routeMeta = useRouteMeta();
    const appletMeta = useAppletMeta();
    const { controller } = useController();
    const pageId = react_1.default.useMemo(() => {
        return (props === null || props === void 0 ? void 0 : props.pageId) || (routeMeta === null || routeMeta === void 0 ? void 0 : routeMeta.pageId);
    }, [props.pageId, routeMeta === null || routeMeta === void 0 ? void 0 : routeMeta.pageId]);
    const routeInfo = react_1.default.useMemo(() => {
        return getRouteInfoByPageId(pageId, controller);
    }, [pageId]);
    let url = react_1.default.useMemo(() => {
        if (routeInfo) {
            const { path } = routeInfo;
            try {
                const pat = new url_pattern_1.default(path);
                return pat.stringify(params);
            }
            catch (e) {
                console.error(e);
                return path;
            }
        }
        return '';
    }, [routeInfo, params]);
    let appletUrl = react_1.default.useMemo(() => {
        if (props.appletId) {
            let mounts = getMountsByPageId(pageId, controller);
            let mount = mounts.find((m) => m.appletId === props.appletId);
            if (!mount) {
                mount = mounts.find((m) => m.appletId === path.join(appletMeta === null || appletMeta === void 0 ? void 0 : appletMeta.featurePath, (props === null || props === void 0 ? void 0 : props.appletId) || ''));
            }
            if (mount) {
                const pat = new url_pattern_1.default(mount.path);
                return pat.stringify(params);
            }
        }
        return '';
    }, [pageId, props.appletId, appletMeta === null || appletMeta === void 0 ? void 0 : appletMeta.featurePath]);
    let finalUrl = react_1.default.useMemo(() => {
        return path.join(url, appletUrl);
    }, [url, appletUrl]);
    finalUrl = react_1.default.useMemo(() => {
        if (props.query) {
            const searchP = new URLSearchParams(props.query);
            if (searchP.size > 0) {
                return `${finalUrl}?${searchP.toString()}`;
            }
        }
        return finalUrl;
    }, [finalUrl, props.query]);
    if (finalUrl && (props === null || props === void 0 ? void 0 : props.children) && finalUrl !== '.') {
        return props.children({ url: finalUrl });
    }
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, {}));
}
exports.LinkDisplay = LinkDisplay;
function Link(props) {
    const { to, target } = props;
    const { push } = useRoute();
    return ((0, jsx_runtime_1.jsx)("a", { className: props.className, target: target, href: to, onClick: (e) => {
            if (e.ctrlKey || e.metaKey) {
                return;
            }
            if (target) {
                return;
            }
            e.preventDefault();
            if (to) {
                push(to);
            }
        }, children: props.children }));
}
exports.Link = Link;
/* -------------------------------------------------------------------------- */
/*                                 Route Ends                                 */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/*                                   Portal                                   */
/* -------------------------------------------------------------------------- */
function importUI(id) {
    return (props) => (0, jsx_runtime_1.jsx)(Applet, Object.assign({}, props, { id: id }));
}
exports.importUI = importUI;
function Applet(props) {
    const { controller } = useController();
    const { id } = props, rest = __rest(props, ["id"]);
    const applet = react_1.default.useMemo(() => {
        for (const applet of controller.applets) {
            const isIdMatching = ((applet === null || applet === void 0 ? void 0 : applet.resolvers) || []).indexOf(id) > -1;
            if (isIdMatching === true) {
                return applet;
            }
        }
    }, [id]);
    if (!applet) {
        return null;
    }
    return ((0, jsx_runtime_1.jsx)(react_1.default.Suspense, { fallback: (0, jsx_runtime_1.jsx)("div", {}), children: (0, jsx_runtime_1.jsx)(applet.Component, Object.assign({}, rest)) }));
}
exports.Applet = Applet;
function Mount(props) {
    const { controller } = useController();
    const routeMeta = useRouteMeta();
    const id = react_1.default.useMemo(() => {
        if (routeMeta === null || routeMeta === void 0 ? void 0 : routeMeta.pageId) {
            const mounts = getMountsByPageId(routeMeta === null || routeMeta === void 0 ? void 0 : routeMeta.pageId, controller);
            const mount = mounts.find((m) => {
                const pattern = new url_pattern_1.default(m.path);
                return Boolean(pattern.match(props.path));
            });
            if (mount) {
                return mount.appletId;
            }
        }
        return null;
    }, [routeMeta === null || routeMeta === void 0 ? void 0 : routeMeta.pageId, props.path]);
    if (id) {
        return ((0, jsx_runtime_1.jsx)(Applet, { id: id }));
    }
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, {}));
}
exports.Mount = Mount;
function getMountsByPageId(pageId, controller) {
    const m = controller.applets.reduce((acc, app) => {
        const matchingMounts = app.mounts.filter((m) => m.pageId === pageId);
        acc.push(...matchingMounts.map((mount) => {
            let pathVal = ((mount === null || mount === void 0 ? void 0 : mount.path) || app.genricPath);
            if (mount === null || mount === void 0 ? void 0 : mount.pathPostfix) {
                pathVal = path.posix.join(pathVal, mount === null || mount === void 0 ? void 0 : mount.pathPostfix);
            }
            return Object.assign(Object.assign({ sort: 0 }, mount), { label: (mount === null || mount === void 0 ? void 0 : mount.label) || app.defaultLabel, path: pathVal, resolvers: app.resolvers, appletId: app.resolvers[0] });
        }));
        return acc;
    }, []).sort((a, b) => {
        if (a.sort > b.sort) {
            return 1;
        }
        else if (a.sort < b.sort) {
            return -1;
        }
        return 0;
    });
    return m;
}
function useMounts() {
    const { controller } = useController();
    const meta = useRouteMeta();
    const mounts = react_1.default.useMemo(() => {
        if (meta === null || meta === void 0 ? void 0 : meta.pageId) {
            return getMountsByPageId(meta === null || meta === void 0 ? void 0 : meta.pageId, controller);
        }
        return [];
    }, [meta === null || meta === void 0 ? void 0 : meta.pageId]);
    return { current: mounts };
}
exports.useMounts = useMounts;
/* -------------------------------------------------------------------------- */
/*                                    Auth                                    */
/* -------------------------------------------------------------------------- */
function Protected(props) {
    const { current } = useLogin();
    if (current.isAuthenticated === false) {
        return ((0, jsx_runtime_1.jsx)(RedirectToLoginPage, {}));
    }
    return props.children;
}
exports.Protected = Protected;
function RedirectToLoginPage() {
    const { controller } = useController();
    let authPageId = react_1.default.useMemo(() => {
        var _a, _b;
        if ((_a = controller === null || controller === void 0 ? void 0 : controller.arkConfig) === null || _a === void 0 ? void 0 : _a.authPageId) {
            return (_b = controller === null || controller === void 0 ? void 0 : controller.arkConfig) === null || _b === void 0 ? void 0 : _b.authPageId;
        }
        return 'login';
    }, [controller]);
    const loginRoute = react_1.default.useMemo(() => {
        var _a;
        if (Array.isArray((_a = controller.arkConfig) === null || _a === void 0 ? void 0 : _a.routes)) {
            return controller.arkConfig.routes.find((r) => r.pageId === authPageId);
        }
        return null;
    }, [authPageId, controller.arkConfig]);
    react_1.default.useEffect(() => {
        if (loginRoute) {
            const { path } = loginRoute;
            const url = new URL('http://localhost');
            url.pathname = path;
            url.searchParams.set('return_path', encodeURIComponent(`${global.window.location.pathname}${global.window.location.search}`));
            window.location.replace(`${url.pathname}${url.search}`);
        }
    }, [loginRoute]);
    return ((0, jsx_runtime_1.jsx)("div", { style: { height: '100vh', width: '100vw', display: 'flex', justifyContent: 'center', alignItems: 'center' } }));
}
exports.RedirectToLoginPage = RedirectToLoginPage;
function goBackToReturnPath() {
    const s = new URLSearchParams(window.location.search);
    if (s.has('return_path')) {
        const returnPath = decodeURIComponent(s.get('return_path'));
        window.location.replace(returnPath);
    }
}
exports.goBackToReturnPath = goBackToReturnPath;
function fallbackRender({ error, resetErrorBoundary }) {
    return ((0, jsx_runtime_1.jsxs)("div", { role: "alert", style: { backgroundColor: 'black', height: '100vh', width: '100vw', overflow: 'auto', padding: 16 }, children: [(0, jsx_runtime_1.jsx)("p", { style: { color: 'white', fontSize: 24 }, children: "Error:" }), (0, jsx_runtime_1.jsx)("pre", { style: { color: "red" }, children: error.message }), (0, jsx_runtime_1.jsx)("pre", { style: { color: "red" }, children: error.stack })] }));
}
function App(props) {
    const controller = react_1.default.useMemo(() => {
        return props.controller || FrontendController.getInstance();
    }, [props.controller]);
    const route = createRoute(props === null || props === void 0 ? void 0 : props.initialPath, controller);
    const socket = (0, socket_1.createSocket)({ controller });
    return ((0, jsx_runtime_1.jsx)(react_error_boundary_1.ErrorBoundary, { fallbackRender: fallbackRender, children: (0, jsx_runtime_1.jsx)(react_helmet_async_1.HelmetProvider, { context: props === null || props === void 0 ? void 0 : props.helmetContext, children: (0, jsx_runtime_1.jsx)(RouteProvider.Provider, { value: route, children: (0, jsx_runtime_1.jsx)(exports.ControllerContext.Provider, { value: controller, children: (0, jsx_runtime_1.jsx)(exports.SocketContext.Provider, { value: socket, children: (0, jsx_runtime_1.jsx)(PageRenderer, {}) }) }) }) }) }));
}
exports.App = App;
function startApp() {
    var _a;
    const rootElem = document.getElementById('root');
    if (rootElem) {
        const shouldHydrate = ((_a = globalThis === null || globalThis === void 0 ? void 0 : globalThis.___ark_hydrated_state___) === null || _a === void 0 ? void 0 : _a.shouldHydrate) === true;
        if (shouldHydrate === true) {
            (0, client_1.hydrateRoot)(rootElem, (0, jsx_runtime_1.jsx)(App, {}));
        }
        else {
            const root = (0, client_1.createRoot)(rootElem);
            root.render((0, jsx_runtime_1.jsx)(App, {}));
        }
    }
}
exports.startApp = startApp;
/* -------------------------------------------------------------------------- */
/*                                   Config                                   */
/* -------------------------------------------------------------------------- */
function loadConfig(config) {
    const properties = (config === null || config === void 0 ? void 0 : config.properties) || [];
    return {
        getValue(propertyName, defaultVal) {
            const p = properties.find((p) => (p === null || p === void 0 ? void 0 : p.name) === propertyName);
            return (p === null || p === void 0 ? void 0 : p.value) || defaultVal;
        }
    };
}
exports.loadConfig = loadConfig;
var file_uploader_1 = require("./file-uploader");
Object.defineProperty(exports, "createUploader", { enumerable: true, get: function () { return file_uploader_1.createUploader; } });
Object.defineProperty(exports, "createSrc", { enumerable: true, get: function () { return file_uploader_1.createSrc; } });
Object.defineProperty(exports, "UploadButton", { enumerable: true, get: function () { return file_uploader_1.UploadButton; } });
var content_1 = require("./content");
Object.defineProperty(exports, "useContent", { enumerable: true, get: function () { return content_1.useContent; } });
var ui_utils_1 = require("./ui-utils");
Object.defineProperty(exports, "uiUtils", { enumerable: true, get: function () { return ui_utils_1.uiUtils; } });
function waitInMs(timeourInMs) {
    return __awaiter(this, void 0, void 0, function* () {
        yield new Promise((r) => setTimeout(() => r(), timeourInMs));
    });
}
exports.waitInMs = waitInMs;
var use_promise_1 = require("./use-promise");
Object.defineProperty(exports, "usePromise", { enumerable: true, get: function () { return use_promise_1.usePromise; } });
