import React from "react";
import { FrontendController } from ".";
import { Socket } from 'socket.io-client';
export declare class SocketController {
}
type Options = {
    controller: FrontendController;
};
export type SocketApi = {
    connect: () => void;
    socket: React.MutableRefObject<Socket<any, any>>;
    subscribe: (ev: string, listener: (...args: any[]) => any) => () => void;
    joinRoom: (rooms?: string[] | string) => () => void;
    leaveRoom: (roomIds: string | string[]) => void;
};
export declare function createSocket(opts: Options): SocketApi;
export declare function useSocket(): void;
export {};
