"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePromise = void 0;
const react_1 = __importDefault(require("react"));
function usePromise(p) {
    const [result, setResult] = react_1.default.useState(null);
    const [error, setErr] = react_1.default.useState(null);
    const [loading, setLoading] = react_1.default.useState(false);
    const refresh = react_1.default.useCallback((...args) => __awaiter(this, void 0, void 0, function* () {
        setLoading(true);
        try {
            const res = yield Promise.resolve(p(...args));
            setResult(res);
        }
        catch (e) {
            console.error(e);
            setErr(e);
        }
        setLoading(false);
    }), [p]);
    return {
        result,
        error,
        refresh,
        loading
    };
}
exports.usePromise = usePromise;
