import type { CSSProperties } from 'react';
interface ImageSettings {
    src: string;
    height: number;
    width: number;
    excavate: boolean;
    x?: number;
    y?: number;
}
export interface QRProps {
    value: string;
    type?: 'canvas' | 'svg';
    size?: number;
    color?: string;
    style?: CSSProperties;
    includeMargin?: boolean;
    imageSettings?: ImageSettings;
    bgColor?: string;
}
export type QRPropsCanvas = QRProps & React.CanvasHTMLAttributes<HTMLCanvasElement>;
export type QRPropsSvg = QRProps & React.SVGAttributes<SVGSVGElement>;
export interface QRCodeProps extends QRProps {
    className?: string;
    rootClassName?: string;
    prefixCls?: string;
    icon?: string;
    iconSize?: number;
    bordered?: boolean;
    errorLevel?: 'L' | 'M' | 'Q' | 'H';
    status?: 'active' | 'expired' | 'loading';
    onRefresh?: () => void;
}
export {};
