"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const fs_1 = require("fs");
const msgpack_1 = require("../json-pack/msgpack");
const CborEncoder_1 = require("../json-pack/cbor/CborEncoder");
const JSONB = tslib_1.__importStar(require("../json-binary"));
const arg_1 = tslib_1.__importDefault(require("arg"));
const args = (0, arg_1.default)({
    '--format': String,
    '--cbor': Boolean,
}, {
    argv: process.argv,
});
const ALLOWED_FORMATS = new Set(['msgpack', 'messagepack', 'cbor']);
const format = args['--cbor']
    ? 'cbor'
    : String(args['--format'] ?? 'msgpack').toLowerCase();
if (!ALLOWED_FORMATS.has(format))
    throw new Error(`Unknown format: ${format}`);
try {
    switch (format) {
        case 'msgpack':
        case 'messagepack': {
            const encoder = new msgpack_1.MsgPackEncoder();
            const buf = (0, fs_1.readFileSync)(0);
            const doc = JSONB.parse(buf.toString());
            const encoded = encoder.encode(doc);
            process.stdout.write(encoded);
            break;
        }
        case 'cbor': {
            const encoder = new CborEncoder_1.CborEncoder();
            const buf = (0, fs_1.readFileSync)(0);
            const doc = JSONB.parse(buf.toString());
            const encoded = encoder.encode(doc);
            process.stdout.write(encoded);
            break;
        }
    }
}
catch (error) {
    const output = error instanceof Error ? error.message : String(error);
    process.stderr.write(output + '\n');
    process.exit(1);
}
