"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.definePatchRoutes = void 0;
const json_patch_1 = require("../../json-patch");
const definePatchRoutes = (router) => {
    return router.extend(({ t, system }) => {
        system.alias('JsonPatch', t.Array(t.any));
        return {
            'patch.apply': t
                .Function(t.Object(t.prop('doc', t.any).options({
                title: 'A document',
                description: 'A JSON document to apply the patch to.',
            }), t.prop('patch', t.Ref('JsonPatch')).options({
                title: 'A JSON Patch',
                description: 'A JSON Patch to apply to the document.',
            })), t.Object(t.propOpt('doc', t.any).options({
                title: '',
                description: 'JSON CRDT document.',
            })))
                .options({
                title: 'Apply JSON Patch to a document',
                description: 'Applies a JSON Patch to a JSON document and returns the result.',
            })
                .implement(async ({ doc, patch }) => {
                (0, json_patch_1.validateOperations)(patch);
                const result = (0, json_patch_1.applyPatch)(doc, patch, { mutate: true });
                return {
                    doc: result.doc,
                };
            }),
        };
    });
};
exports.definePatchRoutes = definePatchRoutes;
