"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const clone_1 = require("../../json-clone/clone");
const values = [
    ['"null"', null],
    ['"false"', false],
    ['integer', 123],
    ['string', 'asdf'],
    ['simple object', { foo: 'bar' }],
    ['simple array', [1, 'a', false]],
];
const testCases = [
    {
        comment: 'Replacing non-existing object key, first level',
        doc: {},
        patch: [{ op: 'replace', path: '/foo', value: 'bar' }],
        error: 'NOT_FOUND',
    },
];
for (const [name, doc] of values) {
    for (const [name2, doc2] of values) {
        testCases.push({
            comment: `Replace root ${name} by ${name2}`,
            doc: (0, clone_1.clone)(doc),
            patch: [{ op: 'replace', path: '', value: (0, clone_1.clone)(doc2) }],
            expected: (0, clone_1.clone)(doc2),
        });
    }
}
for (const [name, doc] of values) {
    for (const [name2, doc2] of values) {
        testCases.push({
            comment: `Replace first level object ${name} by ${name2}`,
            doc: {
                foo: 'bar',
                baz: 123,
                asdf: (0, clone_1.clone)(doc),
                gg: true,
                aha: null,
            },
            patch: [{ op: 'replace', path: '/asdf', value: (0, clone_1.clone)(doc2) }],
            expected: {
                foo: 'bar',
                baz: 123,
                asdf: (0, clone_1.clone)(doc2),
                gg: true,
                aha: null,
            },
        });
    }
}
for (const [name, doc] of values) {
    for (const [name2, doc2] of values) {
        testCases.push({
            comment: `Replace first level object ${name} by ${name2}`,
            doc: {
                foo: 'bar',
                baz: 123,
                test: {
                    '1': 1234,
                    '2': {
                        gg: (0, clone_1.clone)(doc),
                    },
                },
                gg: true,
                aha: null,
            },
            patch: [{ op: 'replace', path: '/test/2/gg', value: (0, clone_1.clone)(doc2) }],
            expected: {
                foo: 'bar',
                baz: 123,
                test: {
                    '1': 1234,
                    '2': {
                        gg: (0, clone_1.clone)(doc2),
                    },
                },
                gg: true,
                aha: null,
            },
        });
    }
}
for (const [name, doc] of values) {
    for (const [name2, doc2] of values) {
        testCases.push({
            comment: `Replace first level array ${name} by ${name2}, in the middle of array`,
            doc: ['bar', 123, false, {}, [], (0, clone_1.clone)(doc), true, null],
            patch: [{ op: 'replace', path: '/5', value: (0, clone_1.clone)(doc2) }],
            expected: ['bar', 123, false, {}, [], (0, clone_1.clone)(doc2), true, null],
        });
    }
}
for (const [name, doc] of values) {
    for (const [name2, doc2] of values) {
        testCases.push({
            comment: `Replace deeply nested array ${name} by ${name2}, at the first position`,
            doc: [
                'bar',
                [
                    123,
                    {
                        hmm: [(0, clone_1.clone)(doc), 1, 2, 3, 4],
                    },
                ],
            ],
            patch: [{ op: 'replace', path: '/1/1/hmm/0', value: (0, clone_1.clone)(doc2) }],
            expected: [
                'bar',
                [
                    123,
                    {
                        hmm: [(0, clone_1.clone)(doc2), 1, 2, 3, 4],
                    },
                ],
            ],
        });
    }
}
exports.default = testCases;
