import * as operations from './operations';
import { ITimestampStruct } from './clock';
import type { Printable } from '../util/print/types';
export type JsonCrdtPatchOperation = operations.NewConOp | operations.NewValOp | operations.NewVecOp | operations.NewObjOp | operations.NewStrOp | operations.NewBinOp | operations.NewArrOp | operations.InsValOp | operations.InsObjOp | operations.InsVecOp | operations.InsStrOp | operations.InsBinOp | operations.InsArrOp | operations.DelOp | operations.NopOp;
export declare class Patch implements Printable {
    static fromBinary(data: Uint8Array): Patch;
    readonly ops: JsonCrdtPatchOperation[];
    meta: unknown;
    getId(): ITimestampStruct | undefined;
    span(): number;
    nextTime(): number;
    rewriteTime(ts: (id: ITimestampStruct) => ITimestampStruct): Patch;
    rebase(serverTime: number, transformHorizon: number): Patch;
    clone(): Patch;
    toBinary(): Uint8Array;
    toString(tab?: string): string;
}
