"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.s = exports.schema = exports.nodes = void 0;
const DelayedValueBuilder_1 = require("./DelayedValueBuilder");
var nodes;
(function (nodes) {
    class con extends DelayedValueBuilder_1.NodeBuilder {
        constructor(raw) {
            super((builder) => builder.const(raw));
            this.raw = raw;
            this.type = 'con';
        }
    }
    nodes.con = con;
    class str extends DelayedValueBuilder_1.NodeBuilder {
        constructor(raw) {
            super((builder) => builder.json(raw));
            this.raw = raw;
            this.type = 'str';
        }
    }
    nodes.str = str;
    class bin extends DelayedValueBuilder_1.NodeBuilder {
        constructor(raw) {
            super((builder) => builder.json(raw));
            this.raw = raw;
            this.type = 'bin';
        }
    }
    nodes.bin = bin;
    class val extends DelayedValueBuilder_1.NodeBuilder {
        constructor(value) {
            super((builder) => {
                const valId = builder.val();
                const valueId = value.build(builder);
                builder.setVal(valId, valueId);
                return valId;
            });
            this.value = value;
            this.type = 'val';
        }
    }
    nodes.val = val;
    class vec extends DelayedValueBuilder_1.NodeBuilder {
        constructor(value) {
            super((builder) => {
                const vecId = builder.vec();
                const length = value.length;
                if (length) {
                    const elementPairs = [];
                    for (let i = 0; i < length; i++) {
                        const element = value[i];
                        const elementId = element.build(builder);
                        elementPairs.push([i, elementId]);
                    }
                    builder.insVec(vecId, elementPairs);
                }
                return vecId;
            });
            this.value = value;
            this.type = 'vec';
        }
    }
    nodes.vec = vec;
    class obj extends DelayedValueBuilder_1.NodeBuilder {
        constructor(obj, opt) {
            super((builder) => {
                const objId = builder.obj();
                const keyValuePairs = [];
                const merged = { ...obj, ...opt };
                const keys = Object.keys(merged);
                const length = keys.length;
                if (length) {
                    for (let i = 0; i < length; i++) {
                        const key = keys[i];
                        const valueId = merged[key].build(builder);
                        keyValuePairs.push([key, valueId]);
                    }
                    builder.insObj(objId, keyValuePairs);
                }
                return objId;
            });
            this.obj = obj;
            this.opt = opt;
            this.type = 'obj';
        }
        optional() {
            return this;
        }
    }
    nodes.obj = obj;
    class arr extends DelayedValueBuilder_1.NodeBuilder {
        constructor(arr) {
            super((builder) => {
                const arrId = builder.arr();
                const length = arr.length;
                if (length) {
                    const valueIds = [];
                    for (let i = 0; i < length; i++)
                        valueIds.push(arr[i].build(builder));
                    builder.insArr(arrId, arrId, valueIds);
                }
                return arrId;
            });
            this.arr = arr;
            this.type = 'arr';
        }
    }
    nodes.arr = arr;
})(nodes || (exports.nodes = nodes = {}));
exports.schema = {
    con: (raw) => new nodes.con(raw),
    str: (str) => new nodes.str(str || ''),
    bin: (bin) => new nodes.bin(bin),
    val: (val) => new nodes.val(val),
    vec: (...vec) => new nodes.vec(vec),
    obj: (obj, opt) => new nodes.obj(obj, opt),
    arr: (arr) => new nodes.arr(arr),
};
exports.s = exports.schema;
