import * as nodes from '../../../nodes';
import { ITimestampStruct, IVectorClock } from '../../../../json-crdt-patch/clock';
import { Model } from '../../../model';
import type * as types from './types';
export declare class Encoder {
    protected model: Model;
    encode(model: Model): types.JsonCrdtVerboseDocument;
    cClock(clock: IVectorClock): types.JsonCrdtVerboseLogicalTimestamp[];
    cTs(ts: ITimestampStruct): types.JsonCrdtVerboseLogicalTimestamp | types.JsonCrdtVerboseServerTimestamp;
    cNode(node: nodes.JsonNode): types.JsonCrdtNode;
    cObj(obj: nodes.ObjNode): types.JsonCrdtVerboseObj;
    cVec(obj: nodes.VecNode): types.JsonCrdtVerboseVec;
    cArr(obj: nodes.ArrNode): types.JsonCrdtVerboseArr;
    cArrChunk(chunk: nodes.ArrChunk): types.JsonCrdtVerboseArrChunk | types.JsonCrdtVerboseTombstone;
    cStr(obj: nodes.StrNode): types.JsonCrdtVerboseStr;
    cStrChunk(chunk: nodes.StrChunk): types.JsonCrdtVerboseStrChunk | types.JsonCrdtVerboseTombstone;
    cBin(obj: nodes.BinNode): types.JsonCrdtVerboseBin;
    cBinChunk(chunk: nodes.BinChunk): types.JsonCrdtVerboseBinChunk | types.JsonCrdtVerboseTombstone;
    cVal(obj: nodes.ValNode): types.JsonCrdtVerboseVal;
    cCon(obj: nodes.ConNode): types.JsonCrdtVerboseCon;
}
