"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ext = void 0;
const DelayedValueBuilder_1 = require("../../json-crdt-patch/builder/DelayedValueBuilder");
const Konst_1 = require("../../json-crdt-patch/builder/Konst");
const ext = (extensionId, nodeBuilder) => new DelayedValueBuilder_1.NodeBuilder((builder) => {
    const buf = new Uint8Array([extensionId, 0, 0]);
    const tupleId = builder.vec();
    buf[1] = tupleId.sid % 256;
    buf[2] = tupleId.time % 256;
    const bufId = builder.constOrJson((0, Konst_1.konst)(buf));
    const valueId = nodeBuilder.build(builder);
    builder.insVec(tupleId, [
        [0, bufId],
        [1, valueId],
    ]);
    return tupleId;
});
exports.ext = ext;
