import { VecNode, ConNode, ObjNode, ArrNode, BinNode, StrNode, ValNode } from '../../nodes';
import { ApiPath, ArrApi, BinApi, ConApi, NodeApi, ObjApi, StrApi, VecApi, ValApi } from './nodes';
import { Emitter } from '../../../util/events/Emitter';
import { Patch } from '../../../json-crdt-patch/Patch';
import { PatchBuilder } from '../../../json-crdt-patch/PatchBuilder';
import type { JsonNode } from '../../nodes';
import type { Model } from '../Model';
export declare class ModelApi<Value extends JsonNode = JsonNode> {
    readonly model: Model<Value>;
    builder: PatchBuilder;
    next: number;
    constructor(model: Model<Value>);
    private changeQueued;
    private readonly queueChange;
    private et;
    get events(): Emitter<{
        change: CustomEvent<unknown>;
    }>;
    wrap(node: ValNode): ValApi;
    wrap(node: StrNode<any>): StrApi;
    wrap(node: BinNode): BinApi;
    wrap(node: ArrNode): ArrApi;
    wrap(node: ObjNode): ObjApi;
    wrap(node: ConNode): ConApi;
    wrap(node: VecNode): VecApi;
    wrap(node: JsonNode): NodeApi;
    get r(): ValApi<import("../../nodes").RootNode<Value>>;
    get node(): import("./types").JsonNodeApi<Value>;
    in(path?: ApiPath): ValApi<ValNode<any>>;
    find(path?: ApiPath): JsonNode<unknown>;
    val(path?: ApiPath): ValApi<ValNode<any>>;
    vec(path?: ApiPath): VecApi<VecNode<any>>;
    str(path?: ApiPath): StrApi;
    bin(path?: ApiPath): BinApi;
    arr(path?: ApiPath): ArrApi<ArrNode<any>>;
    obj(path?: ApiPath): ObjApi<ObjNode<any>>;
    const(path?: ApiPath): ConApi<ConNode<any>>;
    root(json: unknown): this;
    apply(): void;
    advance(): void;
    view(): Readonly<import("../../nodes").JsonNodeView<Value>>;
    flush(): Patch;
}
