"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeEvents = void 0;
const Emitter_1 = require("../../../../util/events/Emitter");
class NodeEvents extends Emitter_1.Emitter {
    constructor(api) {
        super();
        this.api = api;
        this.viewSubs = new Set();
        this._view = undefined;
        this.onModelChange = () => {
            const _view = this._view;
            const view = this.api.node.view();
            const viewHasChanged = _view !== view;
            this._view = view;
            if (viewHasChanged)
                this.emit(new CustomEvent('view'));
        };
    }
    setupViewEvents() {
        this._view = this.api.node.view();
        this.api.api.events.on('change', this.onModelChange);
    }
    on(type, listener, options) {
        if (type === 'view')
            this.viewSubs.add(listener);
        const shouldSubscribeToModelChanges = this.viewSubs.size === 1;
        if (shouldSubscribeToModelChanges)
            this.setupViewEvents();
        super.on(type, listener, options);
    }
    off(type, listener, options) {
        if (type === 'view')
            this.viewSubs.delete(listener);
        const shouldUnsubscribeFromModelChanges = this.viewSubs.size === 1;
        if (shouldUnsubscribeFromModelChanges)
            this.api.api.events.off('change', this.onModelChange);
        super.off(type, listener, options);
    }
}
exports.NodeEvents = NodeEvents;
