"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.find = void 0;
const json_pointer_1 = require("../../../json-pointer");
const nodes_1 = require("../../nodes");
const find = (startNode, path) => {
    const steps = (0, json_pointer_1.toPath)(path);
    let node = startNode;
    const length = steps.length;
    if (!length)
        return node;
    let i = 0;
    while (i < length && node) {
        const step = steps[i++];
        node = node.container();
        if (!node)
            throw new Error('NOT_CONTAINER');
        if (node instanceof nodes_1.ObjNode) {
            const nextNode = node.get(String(step));
            if (!nextNode)
                throw new Error('NOT_FOUND');
            node = nextNode;
        }
        else if (node instanceof nodes_1.ArrNode) {
            const nextNode = node.getNode(Number(step));
            if (!nextNode)
                throw new Error('NOT_FOUND');
            node = nextNode;
        }
        else if (node instanceof nodes_1.VecNode) {
            const nextNode = node.get(Number(step));
            if (!nextNode)
                throw new Error('NOT_FOUND');
            node = nextNode;
        }
    }
    return node;
};
exports.find = find;
