"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Vars = void 0;
const json_pointer_1 = require("../json-pointer");
class Vars {
    constructor(env) {
        this.vars = new Map();
        this.env = env;
    }
    get(name) {
        if (!name)
            return this.env;
        return this.vars.get(name);
    }
    set(name, value) {
        if (!name)
            throw new Error('Invalid varname.');
        this.vars.set(name, value);
    }
    has(name) {
        if (!name)
            return true;
        return this.vars.has(name);
    }
    del(name) {
        if (!name)
            throw new Error('Invalid varname.');
        return this.vars.delete(name);
    }
    find(name, pointer) {
        const data = this.get(name);
        (0, json_pointer_1.validateJsonPointer)(pointer);
        const path = (0, json_pointer_1.toPath)(pointer);
        return (0, json_pointer_1.get)(data, path);
    }
}
exports.Vars = Vars;
