"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEvaluate = void 0;
const tslib_1 = require("tslib");
const util = tslib_1.__importStar(require("./util"));
const createEvaluate = ({ operators, createPattern }) => {
    const evaluate = (expr, ctx) => {
        if (!(expr instanceof Array))
            return expr;
        if (expr.length === 1)
            return expr[0];
        const fn = expr[0];
        const def = operators.get(fn);
        try {
            if (def) {
                const [name, , arity, fn] = def;
                util.assertArity(name, arity, expr);
                return fn(expr, { createPattern, ...ctx, eval: evaluate });
            }
            throw new Error('Unknown expression.');
        }
        catch (err) {
            if (err instanceof Error)
                throw err;
            const error = new Error('Expression evaluation error.');
            error.value = err;
            throw error;
        }
    };
    return evaluate;
};
exports.createEvaluate = createEvaluate;
