"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.binaryOperators = void 0;
const tslib_1 = require("tslib");
const util = tslib_1.__importStar(require("../util"));
const codegen_steps_1 = require("../codegen-steps");
const binaryOperands = (expr, ctx) => {
    const left = ctx.eval(expr[1], ctx);
    const right = ctx.eval(expr[2], ctx);
    return [left, right];
};
exports.binaryOperators = [
    [
        'u8',
        [],
        2,
        (expr, ctx) => {
            const [bin, index] = binaryOperands(expr, ctx);
            return util.u8(bin, index);
        },
        (ctx) => {
            ctx.link(util.u8, 'u8');
            const js = `u8((${ctx.operands[0]}),(${ctx.operands[1]}))`;
            return new codegen_steps_1.Expression(js);
        },
    ],
];
