"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.branchingOperators = void 0;
const codegen_steps_1 = require("../codegen-steps");
exports.branchingOperators = [
    [
        '?',
        ['if'],
        3,
        (expr, ctx) => {
            return ctx.eval(expr[1], ctx) ? ctx.eval(expr[2], ctx) : ctx.eval(expr[3], ctx);
        },
        (ctx) => {
            const condition = ctx.operands[0];
            const then = ctx.operands[1];
            const otherwise = ctx.operands[2];
            if (condition instanceof codegen_steps_1.Literal)
                return condition.val ? then : otherwise;
            return new codegen_steps_1.Expression(`(${condition})?(${then}):(${otherwise})`);
        },
    ],
    [
        'throw',
        [],
        1,
        (expr, ctx) => {
            throw ctx.eval(expr[1], ctx);
        },
        (ctx) => {
            return new codegen_steps_1.Expression(`(function(){throw (${ctx.operands[0]})})()`);
        },
    ],
];
