"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.containerOperators = void 0;
const tslib_1 = require("tslib");
const codegen_steps_1 = require("../codegen-steps");
const util = tslib_1.__importStar(require("../util"));
exports.containerOperators = [
    [
        'len',
        [],
        1,
        (expr, ctx) => {
            return util.len(ctx.eval(expr[1], ctx));
        },
        (ctx) => {
            ctx.link(util.len, 'len');
            const js = `len(${ctx.operands[0]})`;
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        '[]',
        ['member'],
        2,
        (expr, ctx) => {
            const container = ctx.eval(expr[1], ctx);
            const index = ctx.eval(expr[2], ctx);
            return util.member(container, index);
        },
        (ctx) => {
            ctx.link(util.member, 'member');
            const js = `member((${ctx.operands[0]}),(${ctx.operands[1]}))`;
            return new codegen_steps_1.Expression(js);
        },
    ],
];
