"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logicalOperators = void 0;
const codegen_steps_1 = require("../codegen-steps");
exports.logicalOperators = [
    [
        '&&',
        ['and'],
        -1,
        (expr, ctx) => {
            return expr.slice(1).reduce((acc, e) => acc && ctx.eval(e, ctx), true);
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(${expr})`).join('&&');
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        '||',
        ['or'],
        -1,
        (expr, ctx) => {
            return expr.slice(1).reduce((acc, e) => acc || ctx.eval(e, ctx), false);
        },
        (ctx) => {
            const js = ctx.operands.map((expr) => `(${expr})`).join('||');
            return new codegen_steps_1.Expression(js);
        },
    ],
    [
        '!',
        ['not'],
        1,
        (expr, ctx) => {
            return !ctx.eval(expr[1], ctx);
        },
        (ctx) => {
            const js = `!(${ctx.operands[0]})`;
            return new codegen_steps_1.Expression(js);
        },
    ],
];
