"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hash = exports.updateJson = exports.updateStr = exports.updateNum = void 0;
const insertion_1 = require("../util/sort/insertion");
const updateNum = (state, num) => {
    return (state << 5) + state + num;
};
exports.updateNum = updateNum;
const updateStr = (state, str) => {
    let i = str.length;
    while (i)
        state = (state << 5) + state + str.charCodeAt(--i);
    return state;
};
exports.updateStr = updateStr;
const updateJson = (state, json) => {
    switch (typeof json) {
        case 'number':
            return (0, exports.updateNum)(state, json);
        case 'string':
            state = (0, exports.updateNum)(state, 982453601);
            return (0, exports.updateStr)(state, json);
        case 'object': {
            if (json === null)
                return (0, exports.updateNum)(state, 982452847);
            if (json instanceof Array) {
                const length = json.length;
                state = (0, exports.updateNum)(state, 982452259);
                for (let i = 0; i < length; i++)
                    state = (0, exports.updateJson)(state, json[i]);
                return state;
            }
            state = (0, exports.updateNum)(state, 982454533);
            const keys = (0, insertion_1.sort)(Object.keys(json));
            const length = keys.length;
            for (let i = 0; i < length; i++) {
                const key = keys[i];
                state = (0, exports.updateStr)(state, key);
                state = (0, exports.updateJson)(state, json[key]);
            }
            return state;
        }
        case 'boolean':
            return (0, exports.updateNum)(state, json ? 982453247 : 982454243);
    }
    return state;
};
exports.updateJson = updateJson;
const hash = (json) => (0, exports.updateJson)(5381, json) >>> 0;
exports.hash = hash;
