import type { Expr } from '../../../json-expression';
import type { Path } from '../../../json-pointer';
import type { JsonOp, JsonOpDropComponent } from './types';
export declare class PickNode {
    regId: number;
    index: number | string;
    path: Path;
    pathLength: number;
    parent: PickNode | null;
    children: Map<number | string, PickNode>;
    constructor(index: number | string, path: Path, pathLength: number);
    toString(tab?: string): string;
}
export declare class DropNode {
    regId: number;
    index: number | string;
    path: Path;
    pathLength: number;
    parent: DropNode | null;
    children: Map<number | string, DropNode>;
    constructor(index: number | string, path: Path, pathLength: number);
    toString(tab?: string): string;
    clone(): DropNode;
}
export declare class Register {
    readonly id: number;
    pick: PickNode | null;
    data: unknown;
    readonly drops: DropNode[];
    constructor(id: number);
    addDrop(drop: DropNode): void;
    removeDrop(drop: DropNode): void;
    toString(): string;
}
export declare class OpTree {
    static from(op: JsonOp): OpTree;
    protected maxRegId: number;
    test: Expr[];
    pick: PickNode;
    drop: DropNode;
    register: Map<number, Register>;
    constructor();
    findPick(path: Path, pathLength: number): PickNode | undefined;
    findDrop(path: Path, pathLength: number): DropNode | undefined;
    protected setRegister(register: Register): void;
    addPickNode(registerId: number, what: Path, length?: number): Register;
    addData(registerId: number, data: unknown): void;
    addDropNode(registerId: number, where: Path): void;
    compose(other: OpTree): void;
    protected findDeepestDropInPath(path: Path, pathLength?: number): DropNode | null;
    protected removeDrop(drop: DropNode): void;
    protected composeDrops(d1: DropNode, d2: DropNode, tree2: OpTree): void;
    toJson(): JsonOp;
    protected pushDropNode(drop: JsonOpDropComponent[], node: DropNode): void;
    toString(tab?: string): string;
}
