import { Reader } from '../../util/buffers/Reader';
import type { BinaryJsonDecoder, PackValue } from '../types';
export declare class JsonDecoder implements BinaryJsonDecoder {
    reader: Reader;
    read(uint8: Uint8Array): PackValue;
    readAny(): PackValue;
    skipWhitespace(): void;
    readNull(): null;
    readTrue(): true;
    readFalse(): false;
    readBool(): unknown;
    readNum(): number;
    readStr(): string;
    tryReadBin(): Uint8Array | undefined;
    readBin(): Uint8Array;
    readArr(): PackValue[];
    readObj(): Record<string, PackValue>;
}
