"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.codegenOp = void 0;
const test_1 = require("./ops/test");
const starts_1 = require("./ops/starts");
const add_1 = require("./ops/add");
const codegenOp = (op) => {
    switch (op.op()) {
        case 'add':
            return (0, add_1.$add)(op);
        case 'test':
            return (0, test_1.$test)(op);
        case 'starts':
            return (0, starts_1.$starts)(op);
        default:
            return (doc) => op.apply(doc).doc;
    }
};
exports.codegenOp = codegenOp;
