"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.$starts = exports.$$starts = void 0;
const find_1 = require("../../../json-pointer/codegen/find");
const codegen_1 = require("../../../util/codegen");
const util_1 = require("../util");
const $$starts = (op) => {
    const compareValue = op.ignore_case ? op.value.toLowerCase() : op.value;
    const js = `
(function(wrapper){
  var find = ${(0, find_1.$$find)(op.path)};
  return wrapper(function(doc){
    var val = find(doc);
    if (typeof val !== 'string') return false;
    var outer = ${op.ignore_case ? `val.toLowerCase()` : `val`};
    return outer.indexOf(${JSON.stringify(compareValue)}) === 0;
  });
})`;
    return {
        deps: [util_1.predicateOpWrapper],
        js: js,
    };
};
exports.$$starts = $$starts;
const $starts = (op) => (0, codegen_1.compileClosure)((0, exports.$$starts)(op));
exports.$starts = $starts;
