"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.$test = exports.$$test = void 0;
const find_1 = require("../../../json-pointer/codegen/find");
const __deepEqual_1 = require("../../../json-equal/$$deepEqual");
const codegen_1 = require("../../../util/codegen");
const util_1 = require("../util");
const $$test = (op) => {
    const js = `
(function(wrapper){
  var find = ${(0, find_1.$$find)(op.path)};
  var deepEqual = ${(0, __deepEqual_1.$$deepEqual)(op.value)};
  return wrapper(function(doc){
    var val = find(doc);
    if (val === undefined) return ${op.not ? 'true' : 'false'};
    return ${op.not ? '!' : ''}deepEqual(val);
  });
})`;
    return {
        deps: [util_1.predicateOpWrapper],
        js: js,
    };
};
exports.$$test = $$test;
const $test = (op) => (0, codegen_1.compileClosure)((0, exports.$$test)(op));
exports.$test = $test;
