import type { CompactCopyOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationCopy } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpCopy extends AbstractOp<'copy'> {
    readonly from: Path;
    constructor(path: Path, from: Path);
    op(): "copy";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
        old: any;
    };
    toJson(parent?: AbstractOp): OperationCopy;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactCopyOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
