"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpDefined = void 0;
const AbstractPredicateOp_1 = require("./AbstractPredicateOp");
const json_pointer_1 = require("../../json-pointer");
class OpDefined extends AbstractPredicateOp_1.AbstractPredicateOp {
    constructor(path) {
        super(path);
    }
    op() {
        return 'defined';
    }
    code() {
        return 31;
    }
    test(doc) {
        const { val } = (0, json_pointer_1.find)(doc, this.path);
        const test = val !== undefined;
        return test;
    }
    toJson(parent) {
        const op = {
            op: 'defined',
            path: (0, json_pointer_1.formatJsonPointer)(parent ? this.path.slice(parent.path.length) : this.path),
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'defined' : 31;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(2);
        encoder.writer.u8(31);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
    }
}
exports.OpDefined = OpDefined;
