"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpOr = void 0;
const AbstractSecondOrderPredicateOp_1 = require("./AbstractSecondOrderPredicateOp");
const json_pointer_1 = require("../../json-pointer");
class OpOr extends AbstractSecondOrderPredicateOp_1.AbstractSecondOrderPredicateOp {
    constructor(path, ops) {
        super(path, ops);
        this.ops = ops;
    }
    op() {
        return 'or';
    }
    code() {
        return 45;
    }
    test(doc) {
        for (const op of this.ops)
            if (op.test(doc))
                return true;
        return false;
    }
    toJson(parent) {
        const op = {
            op: 'or',
            path: (0, json_pointer_1.formatJsonPointer)(parent ? this.path.slice(parent.path.length) : this.path),
            apply: this.ops.map((op) => op.toJson(this)),
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'or' : 45;
        return [
            opcode,
            parent ? this.path.slice(parent.path.length) : this.path,
            this.ops.map((op) => op.toCompact(this, verbose)),
        ];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(45);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        const length = this.ops.length;
        encoder.encodeArrayHeader(length);
        for (let i = 0; i < length; i++)
            this.ops[i].encode(encoder, this);
    }
}
exports.OpOr = OpOr;
