import type { CompactStrDelOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationStrDel } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpStrDel extends AbstractOp<'str_del'> {
    readonly pos: number;
    readonly str: string | undefined;
    readonly len: number | undefined;
    constructor(path: Path, pos: number, str: string | undefined, len: number | undefined);
    op(): "str_del";
    code(): OPCODE;
    deleteLength(): number;
    apply(doc: unknown): {
        doc: unknown;
        old: string;
    };
    toJson(parent?: AbstractOp): OperationStrDel;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactStrDelOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
