import type { CompactTypeOp } from '../codec/compact/types';
import { AbstractPredicateOp } from './AbstractPredicateOp';
import { OperationType, JsonPatchTypes } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import { AbstractOp } from './AbstractOp';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpType extends AbstractPredicateOp<'type'> {
    readonly value: JsonPatchTypes;
    constructor(path: Path, value: JsonPatchTypes);
    op(): "type";
    code(): OPCODE;
    test(doc: unknown): boolean;
    toJson(parent?: AbstractOp): OperationType;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactTypeOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
