"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliCodecUbjson = void 0;
const UbjsonDecoder_1 = require("../../json-pack/ubjson/UbjsonDecoder");
const UbjsonEncoder_1 = require("../../json-pack/ubjson/UbjsonEncoder");
class CliCodecUbjson {
    constructor(writer) {
        this.writer = writer;
        this.id = 'ubjson';
        this.description = 'UBJSON codec';
        this.encoder = new UbjsonEncoder_1.UbjsonEncoder(writer);
        this.decoder = new UbjsonDecoder_1.UbjsonDecoder();
    }
    encode(value) {
        return this.encoder.encode(value);
    }
    decode(bytes) {
        return this.decoder.read(bytes);
    }
}
exports.CliCodecUbjson = CliCodecUbjson;
