"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamJson = void 0;
const json_patch_1 = require("../../json-patch");
const json_pointer_1 = require("../../json-pointer");
class CliParamJson {
    constructor() {
        this.param = 'json';
        this.short = 'j';
        this.title = 'Set JSON value';
        this.example = '--j/foo=\'{"a":1}\'';
        this.createInstance = (cli, pointer, rawValue) => new (class {
            constructor() {
                this.onRequest = async () => {
                    const value = JSON.parse(String(rawValue));
                    const path = (0, json_pointer_1.toPath)(pointer);
                    cli.request = (0, json_patch_1.applyPatch)(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
                };
            }
        })();
    }
}
exports.CliParamJson = CliParamJson;
