"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamUnd = void 0;
const json_patch_1 = require("../../json-patch");
const json_pointer_1 = require("../../json-pointer");
class CliParamUnd {
    constructor() {
        this.param = 'und';
        this.title = 'Set undefined value';
        this.createInstance = (cli, pointer, rawValue) => new (class {
            constructor() {
                this.onRequest = async () => {
                    const path = (0, json_pointer_1.toPath)(pointer);
                    cli.request = (0, json_patch_1.applyPatch)(cli.request, [{ op: 'add', path, value: undefined }], { mutate: true }).doc;
                };
            }
        })();
    }
}
exports.CliParamUnd = CliParamUnd;
