"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CliParamVersion = void 0;
class CliParamVersion {
    constructor() {
        this.param = 'version';
        this.short = 'v';
        this.title = 'Print version and exit';
        this.createInstance = (cli, pointer, value) => new (class {
            constructor() {
                this.onParam = async () => {
                    const version = cli.options.version ?? '0.0.0-unknown';
                    cli.stdout.write(version + '\n');
                    cli.exit(0);
                };
            }
        })();
    }
}
exports.CliParamVersion = CliParamVersion;
