"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.types = exports.customValidators = void 0;
const json_type_1 = require("../../json-type");
exports.customValidators = [
    {
        name: 'globalId',
        fn: (id) => {
            if (typeof id !== 'string')
                throw new Error('id must be string');
            if (id.length > 10)
                throw new Error('id too long');
        },
    },
];
exports.types = {
    ID: json_type_1.s.String({
        title: 'Global resource ID',
        description: 'Unique identifier for any resource in the system regardless of its type.',
        validator: 'globalId',
    }),
    User: json_type_1.s.Object([
        json_type_1.s.propOpt('type', json_type_1.s.Const('User')),
        json_type_1.s.propOpt('op', json_type_1.s.Const(-1)),
        json_type_1.s.prop('gid', json_type_1.s.Ref('ID')),
        json_type_1.s.prop('id', json_type_1.s.num, {
            title: 'User ID',
            description: 'Unique identifier for a user in the user table.',
        }),
        json_type_1.s.propOpt('name', json_type_1.s.str, {
            title: 'User name',
            description: 'Name of the user as entered during registration.',
        }),
        json_type_1.s.prop('email', json_type_1.s.str),
        json_type_1.s.prop('timeCreated', json_type_1.s.Number({ format: 'u' })),
        json_type_1.s.prop('timeUpdated', json_type_1.s.Number({ format: 'u' })),
        json_type_1.s.prop('scores', json_type_1.s.Array(json_type_1.s.num)),
        json_type_1.s.prop('isActive', json_type_1.s.bool),
        json_type_1.s.prop('null', json_type_1.s.nil),
        json_type_1.s.prop('unknown', json_type_1.s.any),
        json_type_1.s.prop('isUser', json_type_1.s.Const(true)),
        json_type_1.s.prop('isPost', json_type_1.s.Const(false)),
        json_type_1.s.prop('tags', json_type_1.s.Array(json_type_1.s.Or(json_type_1.s.str, json_type_1.s.num))),
        json_type_1.s.prop('meta', json_type_1.s.Object([], {
            unknownFields: true,
        })),
    ], {
        title: 'A user object',
        description: 'Users are entities in the system that represent a human. When user is created, automatically a User entity is assigned to that user.',
    }),
    CrateUserRequest: json_type_1.s.Object([json_type_1.s.prop('user', json_type_1.s.Object([json_type_1.s.propOpt('id', json_type_1.s.num), json_type_1.s.propOpt('name', json_type_1.s.str), json_type_1.s.prop('email', json_type_1.s.str)]))], { title: 'The create user request' }),
    CreateUserResponse: json_type_1.s.Object([json_type_1.s.prop('user', json_type_1.s.Ref('User'))], {
        title: 'A response to a create user request',
        description: 'The response to a create user request.',
    }),
    UpdateUserResponse: json_type_1.s.Object([
        json_type_1.s.prop('user', json_type_1.s.Ref('User')),
        json_type_1.s.prop('changes', json_type_1.s.Number({ format: 'u' }), {
            title: 'The number of fields that were changed',
            description: 'The number of fields that were changed during the update user call.',
        }),
    ], {
        title: 'A response to a create user request',
        description: 'The response to a create user request.',
    }),
    'pubsub.channel.Channel': json_type_1.s.Object([
        json_type_1.s.prop('id', json_type_1.s.str, { title: 'ID of the user' }),
        json_type_1.s.prop('payload', json_type_1.s.Ref('pubsub.channel.PayloadType'), { description: 'Yup, the payload.' }),
        json_type_1.s.prop('meta', json_type_1.s.Object([json_type_1.s.Field('description', json_type_1.s.str)])),
    ], { description: 'A channel' }),
    'pubsub.channel.PayloadType': json_type_1.s.String({
        description: 'The type of payload that is sent to the channel.',
    }),
    'pubsub.channel.CreateChannelResponse': json_type_1.s.Object([
        json_type_1.s.prop('channel', json_type_1.s.Ref('pubsub.channel.Channel')),
        json_type_1.s.prop('project', json_type_1.s.Ref('util.Project')),
    ]),
    'util.Project': json_type_1.s.Object([json_type_1.s.prop('id', json_type_1.s.String({})), json_type_1.s.prop('name', json_type_1.s.str)]),
};
