import * as schema from '../schema';
import * as classes from './classes';
import type { Type } from './types';
import type { TypeSystem } from '../system/TypeSystem';
import type { TypeAlias } from '../system/TypeAlias';
import type { TypeOfAlias } from '../system/types';
export declare class TypeBuilder {
    system?: TypeSystem | undefined;
    constructor(system?: TypeSystem | undefined);
    get any(): classes.AnyType;
    get undef(): classes.ConstType<undefined>;
    get nil(): classes.ConstType<null>;
    get bool(): classes.BooleanType;
    get num(): classes.NumberType;
    get str(): classes.StringType;
    get bin(): classes.BinaryType<classes.AnyType>;
    get arr(): classes.ArrayType<classes.AnyType>;
    get obj(): classes.ObjectType<[]>;
    get fn(): classes.FunctionType<classes.AnyType, classes.AnyType>;
    get fn$(): classes.FunctionStreamingType<classes.AnyType, classes.AnyType>;
    Any(options?: schema.Optional<schema.AnySchema>): classes.AnyType;
    Const<V>(value: V, options?: schema.Optional<schema.ConstSchema>): classes.ConstType<string extends V ? never : number extends V ? never : boolean extends V ? never : any[] extends V ? never : V>;
    Boolean(options?: schema.Optional<schema.BooleanSchema>): classes.BooleanType;
    Number(options?: schema.Optional<schema.NumberSchema>): classes.NumberType;
    String(options?: schema.Optional<schema.StringSchema>): classes.StringType;
    Binary<T extends Type>(type: T, options?: schema.Optional<schema.BinarySchema>): classes.BinaryType<T>;
    Array<T extends Type>(type: T, options?: schema.Optional<schema.ArraySchema>): classes.ArrayType<T>;
    Tuple<F extends Type[]>(...types: F): classes.TupleType<F>;
    Object<F extends classes.ObjectFieldType<any, any>[]>(...fields: F): classes.ObjectType<F>;
    prop<K extends string, V extends Type>(key: K, value: V): classes.ObjectFieldType<K, V>;
    propOpt<K extends string, V extends Type>(key: K, value: V): classes.ObjectOptionalFieldType<K, V>;
    Or<F extends Type[]>(...types: F): classes.OrType<F>;
    Ref<T extends Type | TypeAlias<any, any>>(ref: string): classes.RefType<TypeOfAlias<T>>;
    Function<Req extends Type, Res extends Type>(req: Req, res: Res): classes.FunctionType<Req, Res>;
    Function$<Req extends Type, Res extends Type>(req: Req, res: Res): classes.FunctionStreamingType<Req, Res>;
    import(node: schema.Schema): Type;
    from(value: unknown): Type;
}
