import type { WebSocketBase, CloseEventBase } from './types';
import { Subject, ReplaySubject, BehaviorSubject, Observable } from 'rxjs';
export declare const enum ChannelState {
    CONNECTING = 0,
    OPEN = 1,
    CLOSED = 2
}
export interface Channel<T extends string | Uint8Array = string | Uint8Array> {
    message$: Observable<T>;
    error$: Observable<Error>;
    state$: BehaviorSubject<ChannelState>;
    open$: Observable<Channel>;
    close$: Observable<[self: Channel, event: CloseEventBase]>;
    isOpen(): boolean;
    send(data: T): number;
    send$(data: T): Observable<number>;
    close(code?: number, reason?: string): void;
    buffer(): number;
}
export interface WebSocketChannelParams {
    newSocket: () => WebSocketBase;
}
export declare class WebSocketChannel<T extends string | Uint8Array = string | Uint8Array> implements Channel<T> {
    readonly ws: WebSocketBase | undefined;
    readonly state$: BehaviorSubject<ChannelState>;
    readonly open$: ReplaySubject<Channel<string | Uint8Array>>;
    readonly close$: ReplaySubject<[self: Channel<string | Uint8Array>, event: CloseEventBase]>;
    readonly error$: Subject<Error>;
    readonly message$: Subject<T>;
    constructor({ newSocket }: WebSocketChannelParams);
    buffer(): number;
    close(code?: number, reason?: string): void;
    isOpen(): boolean;
    send(data: T): number;
    send$(data: T): Observable<number>;
}
export interface PersistentChannelParams<T extends string | Uint8Array = string | Uint8Array> {
    newChannel: () => Channel<T>;
    minReconnectionDelay?: number;
    maxReconnectionDelay?: number;
    reconnectionDelayGrowFactor?: number;
    minUptime?: number;
}
export declare class PersistentChannel<T extends string | Uint8Array = string | Uint8Array> {
    readonly params: PersistentChannelParams<T>;
    readonly active$: BehaviorSubject<boolean>;
    readonly channel$: BehaviorSubject<Channel<T> | undefined>;
    readonly open$: BehaviorSubject<boolean>;
    readonly message$: Observable<T>;
    protected retries: number;
    constructor(params: PersistentChannelParams<T>);
    start(): void;
    stop(): void;
    reconnectDelay(): number;
    send$(data: T): Observable<number>;
}
